package yangtz.cs.liu.campus.vo.schoolLab;

import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolTeacherExperimentApplyLabs;

/**
 * 教师个人实验申请对象Vo
 *
 * @author ruoyi
 * @date 2023-08-29
 */
@Data
public class SchoolTeacherExperimentApplyVo extends BaseEntity
{

    private static final long serialVersionUID = 1L;

    /** 教师个人实验申请主键id */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /** 学科（1物理，2化学，3生物） */
    @Excel(name = "学科", readConverterExp = "1=物理,2=化学,3=生物")
    private String sub;

    private List<String> subs;

    /** 级部id */
    private Long gradeId;

    /** 级部 */
    @Excel(name = "级部")
    private String grade;

    /** 学年 */
    @Excel(name = "学年")
    private String schoolYear;

    /** 学期 */
    @Excel(name = "学期")
    private String semester;

    /** 学年+学期 */
    private String schoolYearSemester;

    /** 规划开始时间 */
    @Excel(name = "规划开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date plannedStartTime;

    /** 规划结束时间 */
    @Excel(name = "规划结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date plannedEndTime;

    /** 规划时间 */
    @Excel(name = "规划时间")
    private String plannedTime;

    /** 实验名称 */
    @Excel(name = "实验名称")
    private String experimentName;

    /** 实验分类（1分组实验，2演示实验，3探究实验） */
    @Excel(name = "实验分类", readConverterExp = "1=分组实验,2=演示实验,3=探究实验")
    private String experimentClassify;

    /** 实验用品 */
    @Excel(name = "实验用品")
    private String experimentUseGoods;

    /** 申报状态（0未申报，1已申报，2已阅读，3已分配） */
    @Excel(name = "申报状态", readConverterExp = "0=未申报,1=已申报,2=已阅读,3=已分配")
    private String declareState;

    private List<String> declareStates;

    /** 申报人id */
    private Long applyId;

    /** 申报人名称 */
    @Excel(name = "申报人名称")
    private String applyName;

    /** 申报时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "申报时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date applyTime;

    /** 完成状态（0未完成，1已完成） */
    private String state;

    /** 教师个人实验申请实验室列表 */
    private List<SchoolTeacherExperimentApplyLabs> schoolTeacherExperimentApplyLabsList;

    /** 附件信息集合 */
    private List<SchoolAccessory> schoolAccessoryList;
}
