package yangtz.cs.liu.campus.vo.schoolLab;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;

import java.util.List;

/**
 * 实验室对象Vo
 *
 * @author ruoyi
 * @date 2023-08-29
 */
@Data
public class SchoolLabVo extends BaseEntity
{

    /** 实验室主键id */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /** 实验室名称 */
    @Excel(name = "实验室名称")
    private String labName;

    /** 实验室学科（1物理，2化学，3生物） */
    @Excel(name = "实验室学科", readConverterExp = "1=物理,2=化学,3=生物")
    private String labSub;

    /** 实验室学科集合 */
    private List<String> labSubs;

    /** 负责人id */
    private Long inChargeId;

    /** 负责人 */
    @Excel(name = "负责人")
    private String inChargeName;

    /** 实验室状态（1良好，2正常，3待检查） */
    @Excel(name = "实验室状态", readConverterExp = "1=良好,2=正常,3=待检查")
    private String labState;

    /** 实验室用品 */
    @Excel(name = "实验室用品")
    private String labUseGoods;

    /** 使用状态 */
    private String useState;
}
