package yangtz.cs.liu.campus.vo.schoolLab;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;

import java.util.List;

/**
 * 实验室竞赛对象Vo
 *
 * @author ruoyi
 * @date 2023-08-29
 */
@Data
public class SchoolLabCompetitionVo extends BaseEntity
{

    private static final long serialVersionUID = 1L;

    /** 实验室竞赛主键id */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /** 学年 */
    @Excel(name = "学年")
    private String schoolYear;

    /** 参赛教师id */
    @Excel(name = "参赛教师id")
    private String teacherId;

    /** 参赛教师 */
    @Excel(name = "参赛教师")
    private String teacherName;

    /** 参赛课题 */
    @Excel(name = "参赛课题")
    private String entrySubject;

    /** 比赛项目名称 */
    @Excel(name = "比赛项目名称")
    private String competitionName;

    /** 比赛类型（1说课比赛，2自制教具比赛，3实验教学能力大赛） */
    @Excel(name = "比赛类型", readConverterExp = "1=说课比赛,2=自制教具比赛,3=实验教学能力大赛")
    private String competitionType;

    /** 比赛级别（1省级，2市级） */
    @Excel(name = "比赛级别", readConverterExp = "1=省级,2=市级")
    private String competitionLevel;

    /** 备注1 */
    @Excel(name = "备注1")
    private String remark1;

    /** 备注2 */
    @Excel(name = "备注2")
    private String remark2;

    /** 备注3 */
    @Excel(name = "备注3")
    private String remark3;

    /** 图片信息集合 */
    private List<SchoolAccessory> schoolAccessoryList;
}
