package yangtz.cs.liu.campus.vo.schoolInstrument;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import java.util.Date;

/**
 * 仪器出入库明细对象Vo school_instrument_detail
 *
 * @author ruoyi
 * @date 2023-09-06
 */
@Data
public class SchoolInstrumentDetailVo extends OurBaseEntity {

    /** 仪器id */
    @Excel(name = "仪器id")
    private Long instrumentId;

    /** 仪器名称 */
    @Excel(name = "仪器名称")
    private String instrumentName;

    /** 仪器分类id */
    private Long instrumentTypeId;

    /** 仪器分类 */
    @Excel(name = "仪器分类")
    private String instrumentTypeName;

    /** 变动类型（1出库，2入库） */
    @Excel(name = "变动类型", readConverterExp = "1=出库，2入库")
    private String variationType;

    /** 变动数量 */
    @Excel(name = "变动数量")
    private Integer variationNum;

    /** 旧库存数量 */
    @Excel(name = "旧库存数量")
    private Integer oldStockNum;

    /** 新库存数量 */
    @Excel(name = "新库存数量")
    private Integer newStockNum;

    /** 变更时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "变更时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date variationTime;

    /** 备注 */
    private String remark;

    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date startTime;

    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date endTime;
}
