package yangtz.cs.liu.campus.vo.schoolDuty;

import java.util.List;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 值班管理对象 school_duty
 *
 */
@Data
public class SchoolDutyVo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 标题 */
    @Excel(name = "标题")
    private String dutyName;

    /** 0节日、1寒暑假 */
    @Excel(name = "0节日、1寒暑假")
    private String dutyType;

    /** 假日名称 */
    @Excel(name = "假日名称")
    private String holidayName;

    /** 值班开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "值班开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startDate;

    /** 值班结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "值班结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endDate;

    /** 说明 */
    @Excel(name = "说明")
    private String remarks;

    /** 0未发布  1已发布 */
    @Excel(name = "0未发布  1已发布")
    private String state;

    /** $column.columnComment */
    private String delFlag;

    /** 值班管理明细信息 */
    private List<SchoolDutyDetailsVo> schoolDutyDetailsList;
}
