package yangtz.cs.liu.campus.vo.schoolDepartmentBudget;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;
import yangtz.cs.liu.activiti.domain.ProcessBaseEntity;
import yangtz.cs.liu.campus.domain.schoolDepartmentBudget.SchoolDepartmentBudgetProjectmx;

import java.util.Date;
import java.util.List;

@Data
public class SchoolDepartmentBudgetVo extends ProcessBaseEntity {

    /** 科室预算填报主键id */
    private Long id;

    /** 流程实例id */
    @Excel(name = "流程实例id")
    private String instanceId;

    /** 年度 */
    @Excel(name = "年度")
    private String year;

    /** 科室id */
    @Excel(name = "科室id")
    private Long deptId;

    /** 科室名称 */
    @Excel(name = "科室名称")
    private String deptName;

    /** 填报人id */
    @Excel(name = "填报人id")
    private Long informantId;

    /** 填报人名称 */
    @Excel(name = "填报人名称")
    private String informant;

    /** 分管领导id */
    @Excel(name = "分管领导id")
    private Long leadershipId;

    /** 分管领导名称 */
    @Excel(name = "分管领导名称")
    private String leadershipName;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;

    /** 填报时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "填报时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date tbTime;

    /** 审核状态（0-未提交，1-分管领导审核，2-审核通过，3-审核不通过） */
    @Excel(name = "审核状态", readConverterExp = "0-未提交，1-分管领导审核，2-审核通过，3-审核不通过")
    private String state;

    /** 申请人id */
    @Excel(name = "申请人id")
    private Long applyId;

    /** 申请人 */
    @Excel(name = "申请人")
    private String applyName;

    /** 申请时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "申请时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date applyTime;

    /** 创建人id */
    private Long createById;
    /** 创建人 */
    private String createBy;
    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /** 修改人id */
    private Long updateById;
    /** 修改人 */
    private String updateBy;
    /** 修改时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    /** 科室预算填报项目明细信息 */
    private List<SchoolDepartmentBudgetProjectmx> schoolDepartmentBudgetProjectmxList;
}
