package yangtz.cs.liu.campus.vo.schoolClass;

import com.core.domain.OurBaseEntity;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import javax.validation.constraints.NotNull;

@Data
public class SchoolClassDrVo extends OurBaseEntity {
    private static final long serialVersionUID = 1L;

    /** 当前学年 */
    @Excel(name = "当前学年")
    @NotNull(message = "当前学年不能为空")
    private Integer schoolYear;

    /** l类型1幼儿园2小学3初中4高中 */
    //@Excel(name = "l类型1幼儿园2小学3初中4高中")
    private String classType;

    /** 年级*/
    @Excel(name = "年级",combo = {"一年级","二年级","三年级"},readConverterExp = "1=一年级,2=二年级,3=三年级")
    @NotNull(message = "年级数值不能为空")
    private Integer gradeValue;

    /** 年级名称 */
    //@Excel(name = "年级名称")
    private String gradeName;

    /** 班级 */
    @Excel(name = "班级",combo = {"一班","二班","三班","四班","五班","六班","七班","八班","九班","十班","十一班","十二班","十三班",
            "十四班","十五班","十六班","十七班","十八班","十九班","二十班","二十一班","二十二班","二十三班","二十四班",
            "二十五班","二十六班","二十七班","二十八班","二十九班","三十班","三十一班","三十二班"},
            readConverterExp = "1=一班,2=二班,3=三班,4=四班,5=五班,6=六班,7=七班,8=八班,9=九班,10=十班,11=十一班," +
                    "12=十二班,13=十三班,14=十四班,15=十五班,16=十六班,17=十七班,18=十八班,19=十九班,20=二十班," +
                    "21=二十一班,22=二十二班,23=二十三班,24=二十四班,25=二十五班,26=二十六班,27=二十七班,28=二十八班,29=二十九班,30=三十班,31=三十一班,32=三十二班")
    @NotNull(message = "班级数值不能为空")
    private Integer classValue;

    /** 班级名称 */
    //@Excel(name = "班级名称",width = 25)
    private String className;

    /** 班级别名 */
    @Excel(name = "班级别名",width = 25)
    private String classAlias;

    /** 班主任id */
    private Long teacherId;

    /** 班主任名称 */
    @Excel(name = "班主任名称")
    private String teacherName;

    /** 班主任手机号 */
    @Excel(name = "班主任手机号",width = 25)
    private String teacherTel;

    /** 所在教学楼 */
    @Excel(name = "所在教学楼",width = 25)
    private String houseName;

    /** 是否毕业0正常1毕业 */
    private String isGraduated;

    /** 班徽图片 */
    //@Excel(name = "班徽图片", cellType = Excel.ColumnType.IMAGE,height = 65,type = Excel.Type.EXPORT)
    private String picUrl;

    /** 班级口号 */
    @Excel(name = "班级口号",width = 25)
    private String classSlogan;

    /** 班主任寄语 */
    @Excel(name = "班主任寄语",width = 25)
    private String teacherWord;

    /** 年级id */
    //@Excel(name = "年级id")
    private Long gradeId;

    /** 是否最新学年（0是，1否） */
    //@Excel(name = "是否最新学年", readConverterExp = "0=是，1否")
    private String sfzxxn;

    /** 是否重点班（0是，1否） */
    @Excel(name = "是否重点班",combo = {"是","否"}, readConverterExp = "0=是,1=否")
    private String keyClass;

    /** 选课套餐（下拉框选择） */
    @Excel(name = "选课套餐",combo = {"物理+政治+化学","物理+政治+生物","物理+政治+地理","物理+政治+历史","物理+历史+化学","物理+历史+生物",
            "物理+地理+化学","物理+地理+生物","物理+化学+生物","物理+历史+地理","化学+政治+地理","化学+政治+历史",
            "化学+政治+生物","化学+历史+地理","化学+历史+生物","化学+地理+生物","生物+政治+地理","生物+历史+地理","生物+政治+历史","政治+历史+地理"},
            readConverterExp = "1=物理+政治+化学,2=物理+政治+生物,3=物理+政治+地理,4=物理+政治+历史,5=物理+历史+化学,6=物理+历史+生物," +
                    "7=物理+地理+化学,8=物理+地理+生物,9=物理+化学+生物,10=物理+历史+地理,11=化学+政治+地理,12=化学+政治+历史" +
                    "13=化学+政治+生物,14=化学+历史+地理,15=化学+历史+生物,16=化学+地理+生物,17=生物+政治+地理,18=生物+历史+地理,19=生物+政治+历史,20=政治+历史+地理",width = 25)
    private String chooseCourse;

    private Long teacherId1;
    @Excel(name = "老师姓名1")
    private String teacherName1;

    @Excel(name = "老师电话号码1")
    private String teacherTel1;

    /** 课程名称*/
    @Excel(name = "任课名称1", combo = {"语文","数学","英语","历史","地理","生物","政治","物理","化学","体育","音乐","美术","书法","计算机技术"})
    private String courseName1;

    private Long teacherId2;
    @Excel(name = "老师姓名2")
    private String teacherName2;

    @Excel(name = "老师电话号码2")
    private String teacherTel2;

    /** 课程名称*/
    @Excel(name = "任课名称2", combo = {"语文","数学","英语","历史","地理","生物","政治","物理","化学","体育","音乐","美术","书法","计算机技术"})
    private String courseName2;

    private Long teacherId3;
    @Excel(name = "老师姓名3")
    private String teacherName3;

    @Excel(name = "老师电话号码3")
    private String teacherTel3;

    /** 课程名称*/
    @Excel(name = "任课名称3", combo = {"语文","数学","英语","历史","地理","生物","政治","物理","化学","体育","音乐","美术","书法","计算机技术"})
    private String courseName3;

    private Long teacherId4;
    @Excel(name = "老师姓名4")
    private String teacherName4;

    @Excel(name = "老师电话号码4")
    private String teacherTel4;

    /** 课程名称*/
    @Excel(name = "任课名称4", combo = {"语文","数学","英语","历史","地理","生物","政治","物理","化学","体育","音乐","美术","书法","计算机技术"})
    private String courseName4;

    private Long teacherId5;
    @Excel(name = "老师姓名5")
    private String teacherName5;

    @Excel(name = "老师电话号码5")
    private String teacherTel5;

    /** 课程名称*/
    @Excel(name = "任课名称5", combo = {"语文","数学","英语","历史","地理","生物","政治","物理","化学","体育","音乐","美术","书法","计算机技术"})
    private String courseName5;

    private Long teacherId6;
    @Excel(name = "老师姓名6")
    private String teacherName6;

    @Excel(name = "老师电话号码6")
    private String teacherTel6;

    /** 课程名称*/
    @Excel(name = "任课名称6", combo = {"语文","数学","英语","历史","地理","生物","政治","物理","化学","体育","音乐","美术","书法","计算机技术"})
    private String courseName6;

    private Long teacherId7;
    @Excel(name = "老师姓名7")
    private String teacherName7;

    @Excel(name = "老师电话号码7")
    private String teacherTel7;

    /** 课程名称*/
    @Excel(name = "任课名称7", combo = {"语文","数学","英语","历史","地理","生物","政治","物理","化学","体育","音乐","美术","书法","计算机技术"})
    private String courseName7;

    private Long teacherId8;
    @Excel(name = "老师姓名8")
    private String teacherName8;

    @Excel(name = "老师电话号码8")
    private String teacherTel8;

    /** 课程名称*/
    @Excel(name = "任课名称8", combo = {"语文","数学","英语","历史","地理","生物","政治","物理","化学","体育","音乐","美术","书法","计算机技术"})
    private String courseName8;

    private Long teacherId9;
    @Excel(name = "老师姓名9")
    private String teacherName9;

    @Excel(name = "老师电话号码9")
    private String teacherTel9;

    /** 课程名称*/
    @Excel(name = "任课名称9", combo = {"语文","数学","英语","历史","地理","生物","政治","物理","化学","体育","音乐","美术","书法","计算机技术"})
    private String courseName9;

    private Long teacherId10;
    @Excel(name = "老师姓名10")
    private String teacherName10;

    @Excel(name = "老师电话号码10")
    private String teacherTel10;

    /** 课程名称*/
    @Excel(name = "任课名称10", combo = {"语文","数学","英语","历史","地理","生物","政治","物理","化学","体育","音乐","美术","书法","计算机技术"})
    private String courseName10;

    private Long teacherId11;
    @Excel(name = "老师姓名11")
    private String teacherName11;

    @Excel(name = "老师电话号码11")
    private String teacherTel11;

    /** 课程名称*/
    @Excel(name = "任课名称11", combo = {"语文","数学","英语","历史","地理","生物","政治","物理","化学","体育","音乐","美术","书法","计算机技术"})
    private String courseName11;

    private Long teacherId12;
    @Excel(name = "老师姓名12")
    private String teacherName12;

    @Excel(name = "老师电话号码12")
    private String teacherTel12;

    /** 课程名称*/
    @Excel(name = "任课名称12", combo = {"语文","数学","英语","历史","地理","生物","政治","物理","化学","体育","音乐","美术","书法","计算机技术"})
    private String courseName12;

    private Long teacherId13;
    @Excel(name = "老师姓名13")
    private String teacherName13;

    @Excel(name = "老师电话号码13")
    private String teacherTel13;

    /** 课程名称*/
    @Excel(name = "任课名称13", combo = {"语文","数学","英语","历史","地理","生物","政治","物理","化学","体育","音乐","美术","书法","计算机技术"})
    private String courseName13;

    private Long teacherId14;
    @Excel(name = "老师姓名14")
    private String teacherName14;

    @Excel(name = "老师电话号码14")
    private String teacherTel14;

    /** 课程名称*/
    @Excel(name = "任课名称14", combo = {"语文","数学","英语","历史","地理","生物","政治","物理","化学","体育","音乐","美术","书法","计算机技术"})
    private String courseName14;
}
