package yangtz.cs.liu.campus.vo.schoolAssetsClaim;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class AssetsClaimListVo {
    private Long id;
    /** 领用类型（0个人 1部门） */
    private String claimType;

    /** 归属人、单位ID */
    private Long claimBelong;

    /** 归属人、单位名称 */
    private String claimBelongName;

    /** 资产id */
    private Long assetsId;

    /** 资产名称 */
    private String assetsName;

    /** 规格型号 */
    private String assetsSpecs;

    /** 数量 */
    private Integer assetsNumbers;

    /** 单位 */
    private String assetsUnit;

    /** 资产属性(0固定 1低值易耗品) */
    private String assetsAttribute;

    /** 领用时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date collectDate;

    /** 领用人 */
    private Long collectBy;

    /** 领用人姓名 */
    private String collectByName;

    /** 存放地点 */
    private String depositPlace;

    /** remark */
    private String remark;

    /** 提交状态（0未提交 1已提交） */
    private String state;

}
