package yangtz.cs.liu.campus.vo.office;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;
import yangtz.cs.liu.activiti.domain.ProcessBaseEntity;

import javax.validation.constraints.NotBlank;
import java.util.Date;

@Data
public class OfficeTodoListVO extends ProcessBaseEntity {
    private Long id;

    /** 物品类型 */
    @Excel(name = "物品类型", readConverterExp = "0=教学用品,1=会议用品,2=食堂用品,3=消防用品")
    private String itemType;

    /** 物品名称 */
    @Excel(name = "物品名称")
    private String itemName;

    /** 数量 */
    @Excel(name = "数量")
    private String numbers;

    /** 价格 */
    @Excel(name = "价格")
    private Float price;

    /** 原因 */
    @Excel(name = "原因")
    private String reason;

    /** 状态（0通过，1驳回） */
    //@Excel(name = "状态", readConverterExp = "0=通过，1驳回")
    private Integer state;

    /** 申请人id */
    //@Excel(name = "申请人id")
    private Long applyId;

    /** 采购人id */
    //@Excel(name = "采购人id")
    private Long purchaseId;

    /** 采购内容 完成情况 */
    @Excel(name = "采购内容 完成情况")
    private String purchaseContent;

    /** 类型 */
    //@Excel(name = "类型")
    private String type;

    /** 流程实例ID */
    //@Excel(name = "流程实例ID")
    private String instanceId;

    /** 申请人 */
    @Excel(name = "申请人")
    private String applyUser;

    /** 申请时间 */
    @Excel(name = "申请时间", width = 30, dateFormat = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date applyTime;

    /** 角色组 */
    private String roleKey;
    private String roleName;
}
