package yangtz.cs.liu.campus.vo.device;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;
import yangtz.cs.liu.activiti.domain.ProcessBaseEntity;

import java.util.Date;

@Data
public class RecordTodoVo extends ProcessBaseEntity {

    /** id */
    @Excel(name = "id")
    private Long id;

    /** 流程实例ID */
    @Excel(name = "流程实例ID")
    private String instanceId;

    /** 故障描述 */
    @Excel(name = "故障描述")
    private String faultDescription;

    /** 报修类型 */
    @Excel(name = "报修类型")
    private String repairType;

    /** 提报人 */
    @Excel(name = "提报人")
    private String Informant;

    /** 提报时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "提报时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date reportingTime;

    /** 维修人 */
    @Excel(name = "维修人")
    private String maintainer;

    /** 维修完成时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "维修完成时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date maintenanceCompletionTime;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;

    /** 创建者 */
    @Excel(name = "创建者")
    private String createBy;

    /** 申请人 */
    @Excel(name = "申请人")
    private String applyUser;

    /** 申请时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "申请时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date applyTime;

}
