package yangtz.cs.liu.campus.vo.auditorium;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;
import yangtz.cs.liu.activiti.domain.ProcessBaseEntity;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class SchoolAuditoriumVo extends ProcessBaseEntity {

    /** 礼堂预约id */
    private Long id;

    /** 流程实例id */
    private String instanceId;

    /** 流程实例id */
    private String ddInstanceId;

    /** 活动名称 */
    @Excel(name = "活动名称")
    private String activityName;

    /** 活动场地 */
    @Excel(name = "活动场地")
    private String activityArea;

    /** 活动时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    @Excel(name = "活动时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm")
    private Date activityTime;

    /** 话筒数量 */
    @Excel(name = "话筒数量")
    private Integer htNumber;

    /** 具体负责人id */
    @Excel(name = "具体负责人id")
    private Long specificUserId;

    /** 具体负责人 */
    @Excel(name = "具体负责人")
    private String specificUserName;

    /** 活动人数 */
    @Excel(name = "活动人数")
    private Long activityNumber;

    /** 预计时长 */
    @Excel(name = "预计时长")
    private String duration;

    /** 是否彩排（1-是，0-否） */
    @Excel(name = "是否彩排", combo = {"是","否"}, readConverterExp = "1=是，0=否")
    private String isRehearsal;

    /** 是否录像（1-是，0-否） */
    @Excel(name = "是否录像", combo = {"是","否"}, readConverterExp = "1=是，0=否")
    private String isVideo;

    /** 是否直播（1-是，0-否） */
    @Excel(name = "是否直播", combo = {"是","否"}, readConverterExp = "1=是，0=否")
    private String isLive;

    /** 是否需要大屏（1-是，0-否） */
    @Excel(name = "是否需要大屏", combo = {"是","否"}, readConverterExp = "1=是，0=否")
    private String isBigScreen;

    /** 其他要求 */
    @Excel(name = "其他要求")
    private String otherRequirements;

    /** 学校分管领导id */
    @Excel(name = "学校分管领导id")
    private Long leadershipId;

    /** 学校分管领导 */
    @Excel(name = "学校分管领导")
    private String leadershipName;

    /** 审核状态（0-未提交，1-审核中，2-审核通过，3-审核不通过） */
    @Excel(name = "审核状态", combo = {"未提交","审核中","审核通过","审核不通过"}, readConverterExp = "0=未提交，1=审核中，2=审核通过，3=审核不通过")
    private String state;

    /** 审批意见 */
    @Excel(name = "审批意见")
    private String opinion;

    /** 申请人id */
    @Excel(name = "申请人id")
    private Long applyId;

    /** 申请人 */
    @Excel(name = "申请人")
    private String applyName;

    /** 申请时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "申请时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date applyTime;

    /** 申请部门id */
    @Excel(name = "申请部门id")
    private Long applyDeptId;

    /** 申请部门 */
    @Excel(name = "申请部门")
    private String applyDept;

    /** 附件路径 */
    private String fjlj;

    /** 附件名称 */
    @Excel(name = "附件名称")
    private String fjmc;

    /** 附件下载路径 */
    private String fjxzlj;

    /** 消息任务id */
    private Long ddTaskId;

    /** 创建人id */
    private Long createById;
    /** 创建人 */
    private String createBy;
    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /** 修改人id */
    private Long updateById;
    /** 修改人 */
    private String updateBy;
    /** 修改时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    /** 开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private String startTime;

    /** 结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private String endTime;
}
