package yangtz.cs.liu.campus.util;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.core.domain.VerificationCodeParam;
import com.ruoyi.common.utils.http.HttpUtils;
import java.util.Date;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.wechat.utils.CheckUtil;
import yangtz.cs.liu.wechat.controller.api.VxTemlateController;

/**
 * 调用模板发送信息
 */
@Service
public class VxTemlateSendApi {

  /**
   * 发送模板信息
   */
  /**
   * 测试环境路径
   */
  private  static String url = "http://xrwpuc.natappfree.cc/houduan/vx/temlateses/sendTemlate";

  /**
   * 签名key
   */
  private static  String ticketSecrets = "71_0xakqv3T3ORjyXPeP-s2rwRcAqDbMEmmmkfMQeeJJmXBM8g-W4p4oa5BKisL-FYVHMzLJLyzbhgFQUfOkBW8Ufr4SWTTgGpjGs-BmIi8V95ct5hAXtQ47xDetjoLSSiAFAXEE";

  @Autowired
  VxTemlateController vxTemlateController;
  /**
   *
   * @param map
   * toUserOpenId  微信用户id
   * applyTime  申请时间
   * remark    备注
   * applyUser   用户名字
   * content    内容
   * first   标题
   * @return
   */
 public static String sendVxTemlate(Map<String,Object> map){
   long timestamp = System.currentTimeMillis();
    CheckUtil checkUtil = new CheckUtil(ticketSecrets);
    checkUtil.setMap(map);
    checkUtil.setValue("timeStamp",timestamp);
    VerificationCodeParam verificationCodeParam = new VerificationCodeParam();
    verificationCodeParam.setSign(checkUtil.makeSign());
    verificationCodeParam.setMap(map);
    verificationCodeParam.setTimeStamp(timestamp);
    String jsonString = JSON.toJSONString(verificationCodeParam);
    JSONObject jsonObject = JSONObject.parseObject(jsonString);
    String post = HttpUtils.sendJsonPost(url, jsonObject);
    return post;
  }

}
