package yangtz.cs.liu.campus.service.thesis;

import java.util.List;
import yangtz.cs.liu.campus.domain.thesis.Thesis;

/**
 * 论文情况Service接口
 *
 * @author ruoyi
 * @date 2023-07-25
 */
public interface IThesisService
{
    /**
     * 查询论文情况
     *
     * @param id 论文情况主键
     * @return 论文情况
     */
    public Thesis selectThesisById(Long id);

    /**
     * 查询论文情况列表
     *
     * @param thesis 论文情况
     * @return 论文情况集合
     */
    public List<Thesis> selectThesisList(Thesis thesis);

    /**
     * 新增论文情况
     *
     * @param thesis 论文情况
     * @return 结果
     */
    public int insertThesis(Thesis thesis);

    /**
     * 修改论文情况
     *
     * @param thesis 论文情况
     * @return 结果
     */
    public int updateThesis(Thesis thesis);

    /**
     * 批量删除论文情况
     *
     * @param ids 需要删除的论文情况主键集合
     * @return 结果
     */
    public int deleteThesisByIds(Long[] ids);

    /**
     * 删除论文情况信息
     *
     * @param id 论文情况主键
     * @return 结果
     */
    public int deleteThesisById(Long id);
}
