package yangtz.cs.liu.campus.service.teacher;

import com.baomidou.mybatisplus.extension.service.IService;
import com.ruoyi.common.core.domain.entity.SchoolTeacher;
import yangtz.cs.liu.campus.domain.office.SchoolOfficePurchase;
import yangtz.cs.liu.campus.domain.student.SchoolStudentLeave;
import yangtz.cs.liu.campus.domain.teacher.SchoolTeacherLeave;
import yangtz.cs.liu.campus.domain.teacher.SchoolTeacherOvertime;
import yangtz.cs.liu.campus.vo.office.OfficeTodoListVO;
import yangtz.cs.liu.campus.vo.teacher.SchoolTeacherLeaveVO;
import yangtz.cs.liu.campus.vo.teacher.SchoolTeacherVO;
import yangtz.cs.liu.campus.vo.teacher.TeacherLeaveVO;
import yangtz.cs.liu.wechat.vo.common.WorkFlowVo;

import java.util.List;
import java.util.Map;

public interface ISchoolTeacherLeaveService extends IService<SchoolTeacherLeave> {

    /**
     * 查询老师请假列表
     */
    List<TeacherLeaveVO>  selectSchoolTeacherLeaveList(String submitState,SchoolTeacherLeave schoolTeacherLeave);

    /**
     * 教职工信息汇总（请假申请通过的数据）
     */
    List<TeacherLeaveVO>  getList(SchoolTeacherLeave schoolTeacherLeave);

    /**教工请假新增*/
    int addLeave(SchoolTeacherLeaveVO vo);

    /*
    * 删除老师请假列表
    * */
    int removeSchoolTeacherLeaveByIds(List<Long> ids);
    /**
     * 流程定义
     * @param schoolTeacherLeave
     * @param username
     * @param key
     * @param variables
     */
    int submitApply(SchoolTeacherLeave schoolTeacherLeave, String username, String key, Map<String, Object> variables);

    /**
     * 待办列表
     *
     * @param entity
     * @param userId
     * @return
     */
    List<TeacherLeaveVO> findTodoTasks(String key, SchoolTeacherLeave entity, String userId);

    /**
     * 已办列表
     * @param key
     * @param entity
     * @param userId
     * @return
     */
    List<TeacherLeaveVO> findDoneTasks(String key, SchoolTeacherLeave entity, String userId);

    /**
     * 待办已办
     * */
    List<TeacherLeaveVO> findTasks(String key, String userId);


    /**
     *
     * @author lyric
     * @date 2022/10/28 10:44
     * @param taskId
     * @param schoolTeacherLeave
     * 销假
     */
    void cancelLeave(String taskId, SchoolTeacherLeave schoolTeacherLeave);

    TeacherLeaveVO selectById(Long id);

    /**
     * 获取级部主任或处室主任
     * */
    List<SchoolTeacher> getLeader(Long applyOrgid, String employeeType, SchoolTeacherVO teacherVO);

    /**
     * 教工请假时长处理
     * */
    public int teacherLeaveDeal(SchoolTeacherLeave leave, List<String> restList);

    /**
     * 职工请假时长处理
     * */
    public double workerLeaveDeal(SchoolTeacherLeave leave,List<String> restList);

    /**
     * 判断时间是否传递，是否合理
     * */
    public void judgeDate(SchoolTeacherLeave leave);

    /**
     * 根据请假总时长判断用户是否选择对应节点的审批人
     * */
    public void judgeHandUser(SchoolTeacherLeave leave);

    /**
     * 教师请假-修改
     * */
    int editLeave(SchoolTeacherLeave schoolTeacherLeave);

    WorkFlowVo workFlows(Long id);
}
