package yangtz.cs.liu.campus.service.schoolexam;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.schoolexam.SchoolExam;
import yangtz.cs.liu.campus.domain.schoolexam.SchoolExamDetail;

import java.util.Date;
import java.util.List;

/**
 * 学校考试信息Service接口
 *
 * @author ruoyi
 * @date 2022-09-29
 */
public interface ISchoolExamService extends IService<SchoolExam> {
    /**
     * 学校考试信息查询
     * @param schoolExam
     * @return
     */
    public List<SchoolExam> queryList(SchoolExam schoolExam);

    public boolean saveNew(SchoolExam schoolExam);

    public boolean updateByIdNew(SchoolExam schoolExam);

    public String importExamDetail(List<SchoolExam> list);

    public void check(List<SchoolExam> list);


    /**
     * 公众号：家长获取孩子所有考试成绩
     * @param schoolExam
     * @return
     */
    List<SchoolExam> getChildExam(Long studentId,SchoolExam schoolExam);
}
