package yangtz.cs.liu.campus.service.schoolSecurity;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.schoolSecurity.SchoolVehicleInOut;
import yangtz.cs.liu.campus.vo.schoolSecurity.SchoolVehicleInOutVo;

import java.util.List;
import java.util.Map;

/**
 * 车辆出入登记Service接口
 *
 * @author ruoyi
 * @date 2023-09-11
 */
public interface ISchoolVehicleInOutService extends IService<SchoolVehicleInOut>
{

    /**
     * 查询车辆出入登记
     *
     * @param id 车辆出入登记主键
     * @return 车辆出入登记
     */
    public SchoolVehicleInOutVo selectSchoolVehicleInOutById(Long id);

    /**
     * 查询车辆出入登记列表
     *
     * @param schoolVehicleInOutVo 车辆出入登记
     * @return 车辆出入登记集合
     */
    public List<SchoolVehicleInOutVo> selectSchoolVehicleInOutList(SchoolVehicleInOutVo schoolVehicleInOutVo);

    /**
     * 新增车辆出入登记
     *
     * @param schoolVehicleInOutVo 车辆出入登记
     * @return 结果
     */
    public int insertSchoolVehicleInOut(SchoolVehicleInOutVo schoolVehicleInOutVo);

    /**
     * 修改车辆出入登记
     *
     * @param schoolVehicleInOutVo 车辆出入登记
     * @return 结果
     */
    public int updateSchoolVehicleInOut(SchoolVehicleInOutVo schoolVehicleInOutVo);

    /**
     * 批量删除车辆出入登记
     *
     * @param ids 需要删除的车辆出入登记主键集合
     * @return 结果
     */
    public int deleteSchoolVehicleInOutByIds(Long[] ids);

    /**
     * 删除车辆出入登记信息
     *
     * @param id 车辆出入登记主键
     * @return 结果
     */
    public int deleteSchoolVehicleInOutById(Long id);

    /**
     * 获取当前登录人车辆登记信息
     * @param userId
     * @return
     */
    public List<Map<String,String>> getUserVehicle(Long userId);

    /**
     * 新增车辆出入登记信息
     * @param schoolVehicleInOutVo
     * @return
     */
    int insertSchoolVehicleInOutVo(SchoolVehicleInOutVo schoolVehicleInOutVo);
}
