package yangtz.cs.liu.campus.service.schoolLab;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolTeacherExperimentApply;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolTeacherExperimentApplyVo;

import java.util.List;

/**
 * 教师个人实验申请Service接口
 *
 * @author ruoyi
 * @date 2023-08-29
 */
public interface ISchoolTeacherExperimentApplyService extends IService<SchoolTeacherExperimentApply>
{
    /**
     * 查询教师个人实验申请
     *
     * @param id 教师个人实验申请主键
     * @return 教师个人实验申请
     */
    public SchoolTeacherExperimentApplyVo selectSchoolTeacherExperimentApplyById(Long id);

    /**
     * 查询教师个人实验申请列表
     *
     * @param schoolTeacherExperimentApplyVo 教师个人实验申请
     * @return 教师个人实验申请集合
     */
    public List<SchoolTeacherExperimentApplyVo> selectSchoolTeacherExperimentApplyList(SchoolTeacherExperimentApplyVo schoolTeacherExperimentApplyVo);

    /**
     * 查询教师个人实验申请列表
     *
     * @param schoolTeacherExperimentApplyVo 教师个人实验申请
     * @return 教师个人实验申请集合
     */
    public List<SchoolTeacherExperimentApplyVo> getTeacherList(SchoolTeacherExperimentApplyVo schoolTeacherExperimentApplyVo);

    /**
     * 新增教师个人实验申请
     *
     * @param schoolTeacherExperimentApply 教师个人实验申请
     * @return 结果
     */
    public int insertSchoolTeacherExperimentApply(SchoolTeacherExperimentApplyVo schoolTeacherExperimentApply);

    /**
     * 修改教师个人实验申请
     *
     * @param schoolTeacherExperimentApply 教师个人实验申请
     * @return 结果
     */
    public int updateSchoolTeacherExperimentApply(SchoolTeacherExperimentApplyVo schoolTeacherExperimentApply);

    /**
     * 批量删除教师个人实验申请
     *
     * @param ids 需要删除的教师个人实验申请主键集合
     * @return 结果
     */
    public int deleteSchoolTeacherExperimentApplyByIds(Long[] ids);

    /**
     * 删除教师个人实验申请信息
     *
     * @param id 教师个人实验申请主键
     * @return 结果
     */
    public int deleteSchoolTeacherExperimentApplyById(Long id);

    /**
     * 实验室管理-教师个人演示实验审批-分配实验室
     * @param schoolTeacherExperimentApplyVo
     * @return
     */
    int teacherExperimentLabs(SchoolTeacherExperimentApplyVo schoolTeacherExperimentApplyVo);

    /**
     * 上传实验结果附件
     * @param schoolTeacherExperimentApplyVo
     * @return
     */
    int experimentResult(SchoolTeacherExperimentApplyVo schoolTeacherExperimentApplyVo);
}
