package yangtz.cs.liu.campus.service.schoolLab;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolLab;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolLabVo;

import java.util.List;
import java.util.Map;

/**
 * 实验室Service接口
 *
 * @author ruoyi
 * @date 2023-08-29
 */
public interface ISchoolLabService extends IService<SchoolLab>
{

    /**
     * 查询实验室
     *
     * @param id 实验室主键
     * @return 实验室
     */
    public SchoolLabVo selectSchoolLabById(Long id);

    /**
     * 查询实验室列表
     *
     * @param schoolLabVo 实验室
     * @return 实验室集合
     */
    public List<SchoolLabVo> selectSchoolLabList(SchoolLabVo schoolLabVo,Long userId);

    /**
     * 新增实验室
     *
     * @param schoolLab 实验室
     * @return 结果
     */
    public int insertSchoolLab(SchoolLab schoolLab);

    /**
     * 修改实验室
     *
     * @param schoolLab 实验室
     * @return 结果
     */
    public int updateSchoolLab(SchoolLab schoolLab);

    /**
     * 批量删除实验室
     *
     * @param ids 需要删除的实验室主键集合
     * @return 结果
     */
    public int deleteSchoolLabByIds(Long[] ids);

    /**
     * 删除实验室信息
     *
     * @param id 实验室主键
     * @return 结果
     */
    public int deleteSchoolLabById(Long id);

    /**
     * 获获取实验室负责人下拉框
     */
    List<Map<String, String>> getLabAdmin();

    /**
     * 获取学科下拉框
     * @return
     */
    List<Map<String, String>> getSub();

}
