package yangtz.cs.liu.campus.service.schoolLab;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolExperimentPlan;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolExperimentPlanVo;

import java.util.List;
import java.util.Map;

/**
 * 实验计划Service接口
 *
 * @author ruoyi
 * @date 2023-08-29
 */
public interface ISchoolExperimentPlanService extends IService<SchoolExperimentPlan>
{

    /**
     * 查询实验计划
     *
     * @param id 实验计划主键
     * @return 实验计划
     */
    public SchoolExperimentPlanVo selectSchoolExperimentPlanById(Long id);

    /**
     * 查询实验计划列表
     *
     * @param schoolExperimentPlanVo 实验计划
     * @return 实验计划集合
     */
    public List<SchoolExperimentPlanVo> selectSchoolExperimentPlanList(SchoolExperimentPlanVo schoolExperimentPlanVo);
    public List<Map<String,String>> selectNameByVo(SchoolExperimentPlanVo schoolExperimentPlanVo);

    /**
     * 查询实验计划列表(管理员)
     *
     * @param schoolExperimentPlanVo 实验计划
     * @return 实验计划集合
     */
    public List<SchoolExperimentPlanVo> selectExperimentPlanListAdmin(SchoolExperimentPlanVo schoolExperimentPlanVo);

    /**
     * 新增实验计划
     *
     * @param schoolExperimentPlanVo 实验计划
     * @return 结果
     */
    public int insertSchoolExperimentPlan(SchoolExperimentPlanVo schoolExperimentPlanVo);

    /**
     * 修改实验计划
     *
     * @param schoolExperimentPlanVo 实验计划
     * @return 结果
     */
    public int updateSchoolExperimentPlan(SchoolExperimentPlanVo schoolExperimentPlanVo);

    /**
     * 批量删除实验计划
     *
     * @param ids 需要删除的实验计划主键集合
     * @return 结果
     */
    public int deleteSchoolExperimentPlanByIds(Long[] ids);

    /**
     * 删除实验计划信息
     *
     * @param id 实验计划主键
     * @return 结果
     */
    public int deleteSchoolExperimentPlanById(Long id);

    /**
     * 根据学年查询级部下拉框
     * @param schoolYear
     * @return
     */
    List<Map<String,Object>> getGrade(int schoolYear,Long userId);

    /**
     * 查询级部下拉框(搜索条件)
     * @param schoolYear
     * @return
     */
    List<Map<String,Object>> getGradeList(int schoolYear);

    /**
     * 根据级部查询对应班级
     * @param gradeId
     * @return
     */
    List<Map<String,Object>> getSchoolClass(Long gradeId);

    List<Map<String,String>> getSub(Long gradeId);

    /**
     * 实验室管理-级部实验计划查看列表
     * @param schoolExperimentPlanVo
     * @return
     */
    List<SchoolExperimentPlanVo> getExperimentList(SchoolExperimentPlanVo schoolExperimentPlanVo);

    /**
     * 领导-查看实验室完成情况列表
     * @param schoolExperimentPlanVo
     * @return
     */
    List<Map<String,Object>> countExperiment(SchoolExperimentPlanVo schoolExperimentPlanVo);

    /**
     * 实验室管理-查看实验室完成情况列表
     * @param schoolExperimentPlanVo
     * @return
     */
    List<Map<String,Object>> countExperimentAdmin(SchoolExperimentPlanVo schoolExperimentPlanVo);

    /**
     * 级部-实验室完成情况明细
     * @param schoolExperimentPlanVo
     * @return
     */
    List<Map<String, Object>> gradeCountExperiment(SchoolExperimentPlanVo schoolExperimentPlanVo);

    /**
     * 实验室完成情况明细(管理员)
     * @param schoolExperimentPlanVo
     * @return
     */
    List<Map<String, Object>> countExperimentListAdmin(SchoolExperimentPlanVo schoolExperimentPlanVo);
}
