package yangtz.cs.liu.campus.service.schoolInstrument;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.schoolInstrument.SchoolTeacherBorrow;
import yangtz.cs.liu.campus.vo.schoolInstrument.SchoolTeacherBorrowVo;

import java.util.List;

/**
 * 教师借用Service接口
 *
 * @author ruoyi
 * @date 2023-09-06
 */
public interface ISchoolTeacherBorrowService extends IService<SchoolTeacherBorrow> {

    /**
     * 查询教师借用
     *
     * @param id 教师借用主键
     * @return 教师借用
     */
    public SchoolTeacherBorrowVo selectSchoolTeacherBorrowById(Long id);

    /**
     * 查询教师借用列表
     *
     * @param schoolTeacherBorrowVo 教师借用
     * @return 教师借用集合
     */
    public List<SchoolTeacherBorrowVo> selectSchoolTeacherBorrowList(SchoolTeacherBorrowVo schoolTeacherBorrowVo);

    /**
     * 新增教师借用
     *
     * @param schoolTeacherBorrowVo 教师借用
     * @return 结果
     */
    public int insertSchoolTeacherBorrow(SchoolTeacherBorrowVo schoolTeacherBorrowVo);

    /**
     * 修改教师借用
     *
     * @param schoolTeacherBorrowVo 教师借用
     * @return 结果
     */
    public int updateSchoolTeacherBorrow(SchoolTeacherBorrowVo schoolTeacherBorrowVo);

    /**
     * 批量删除教师借用
     *
     * @param ids 需要删除的教师借用主键集合
     * @return 结果
     */
    public int deleteSchoolTeacherBorrowByIds(Long[] ids);

    /**
     * 删除教师借用信息
     *
     * @param id 教师借用主键
     * @return 结果
     */
    public int deleteSchoolTeacherBorrowById(Long id);

    /**
     * 仓库借用管理列表
     * @param schoolTeacherBorrowVo
     * @return
     */
    List<SchoolTeacherBorrowVo> selectBorrowInstrumentList(SchoolTeacherBorrowVo schoolTeacherBorrowVo);

    /**
     * 归还教师借出仪器
     * @param schoolTeacherBorrowVo
     * @return
     */
    int returnInstrument(SchoolTeacherBorrowVo schoolTeacherBorrowVo);
}
