package yangtz.cs.liu.campus.service.schoolInstrument;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.schoolInstrument.SchoolInstrument;
import yangtz.cs.liu.campus.vo.schoolInstrument.SchoolInstrumentVo;

import java.util.List;

/**
 * 仪器管理Service接口
 *
 * @author ruoyi
 * @date 2023-09-06
 */
public interface ISchoolInstrumentService extends IService<SchoolInstrument> {

    /**
     * 查询仪器管理
     *
     * @param id 仪器管理主键
     * @return 仪器管理
     */
    public SchoolInstrument selectSchoolInstrumentById(Long id);

    /**
     * 查询仪器管理列表
     *
     * @param schoolInstrument 仪器管理
     * @return 仪器管理集合
     */
    public List<SchoolInstrument> selectSchoolInstrumentList(SchoolInstrument schoolInstrument);

    /**
     * 新增仪器管理
     *
     * @param schoolInstrument 仪器管理
     * @return 结果
     */
    public int insertSchoolInstrument(SchoolInstrument schoolInstrument);

    /**
     * 修改仪器管理
     *
     * @param schoolInstrument 仪器管理
     * @return 结果
     */
    public int updateSchoolInstrument(SchoolInstrument schoolInstrument);

    /**
     * 批量删除仪器管理
     *
     * @param ids 需要删除的仪器管理主键集合
     * @return 结果
     */
    public int deleteSchoolInstrumentByIds(Long[] ids);

    /**
     * 删除仪器管理信息
     *
     * @param id 仪器管理主键
     * @return 结果
     */
    public int deleteSchoolInstrumentById(Long id);

    /**
     * 教师借用明细列表
     * @param schoolInstrumentVo
     * @return
     */
    List<SchoolInstrument> selectInstrumentList(SchoolInstrumentVo schoolInstrumentVo);
}
