package yangtz.cs.liu.campus.service.schoolInstrument;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.schoolInstrument.SchoolInstrumentDetail;
import yangtz.cs.liu.campus.vo.schoolInstrument.SchoolInstrumentDetailVo;

import java.util.List;

/**
 * 仪器出入库明细Service接口
 *
 * @author ruoyi
 * @date 2023-09-06
 */
public interface ISchoolInstrumentDetailService extends IService<SchoolInstrumentDetail> {

    /**
     * 查询仪器出入库明细
     *
     * @param id 仪器出入库明细主键
     * @return 仪器出入库明细
     */
    public SchoolInstrumentDetail selectSchoolInstrumentDetailById(Long id);

    /**
     * 查询仪器出入库明细列表
     *
     * @param schoolInstrumentDetailVo 仪器出入库明细
     * @return 仪器出入库明细集合
     */
    public List<SchoolInstrumentDetail> selectSchoolInstrumentDetailList(SchoolInstrumentDetailVo schoolInstrumentDetailVo);

    /**
     * 新增仪器出入库明细
     *
     * @param schoolInstrumentDetail 仪器出入库明细
     * @return 结果
     */
    public int insertSchoolInstrumentDetail(SchoolInstrumentDetail schoolInstrumentDetail);

    /**
     * 修改仪器出入库明细
     *
     * @param schoolInstrumentDetail 仪器出入库明细
     * @return 结果
     */
    public int updateSchoolInstrumentDetail(SchoolInstrumentDetail schoolInstrumentDetail);

    /**
     * 批量删除仪器出入库明细
     *
     * @param ids 需要删除的仪器出入库明细主键集合
     * @return 结果
     */
    public int deleteSchoolInstrumentDetailByIds(Long[] ids);

    /**
     * 删除仪器出入库明细信息
     *
     * @param id 仪器出入库明细主键
     * @return 结果
     */
    public int deleteSchoolInstrumentDetailById(Long id);
}
