package yangtz.cs.liu.campus.service.schoolEquipment;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.schoolEquipment.SchoolReceive;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolReceiveVo;

import java.util.List;

public interface IReceiveService extends IService<SchoolReceive> {
    /**
     * 查看设备领用列表
     * @param schoolReceiveVo
     * @return
     */
    List<SchoolReceiveVo> selectSchoolReceiveVoList(SchoolReceiveVo schoolReceiveVo);

    /**
     * 查看设备领用详细信息
     * @param id
     * @return
     */
    SchoolReceiveVo selectSchoolReceiveVoById(Long id);

    /**
     * 新增设备领用
     * @param schoolReceive
     * @return
     */
    int insertSchoolReceive(SchoolReceive schoolReceive);

    /**
     * 修改设备领用
     * @param schoolReceive
     * @return
     */
    int updateSchoolReceive(SchoolReceive schoolReceive);

    /**
     * 删除设备领用
     * @param ids
     * @return
     */
    int deleteSchoolReceiveByIds(Long[] ids);
}
