package yangtz.cs.liu.campus.service.schoolDepartmentBudget;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.schoolDepartmentBudget.SchoolDepartmentBudget;
import yangtz.cs.liu.campus.vo.schoolDepartmentBudget.SchoolDepartmentBudgetVo;

import java.util.List;
import java.util.Map;

/**
 * 科室预算填报Service接口
 *
 * @author ruoyi
 * @date 2023-07-11
 */
public interface ISchoolDepartmentBudgetService extends IService<SchoolDepartmentBudget>
{
    /**
     * 查询科室预算填报
     *
     * @param id 科室预算填报主键
     * @return 科室预算填报
     */
    public SchoolDepartmentBudgetVo selectSchoolDepartmentBudgetById(Long id);

    /**
     * 查询科室预算填报列表
     *
     * @param schoolDepartmentBudget 科室预算填报
     * @return 科室预算填报集合
     */
    public List<SchoolDepartmentBudgetVo> selectSchoolDepartmentBudgetList(SchoolDepartmentBudget schoolDepartmentBudget);

    /**
     * 新增科室预算填报
     *
     * @param schoolDepartmentBudget 科室预算填报
     * @return 结果
     */
    public int insertSchoolDepartmentBudget(SchoolDepartmentBudgetVo schoolDepartmentBudget);

    /**
     * 修改科室预算填报
     *
     * @param schoolDepartmentBudget 科室预算填报
     * @return 结果
     */
    public int updateSchoolDepartmentBudget(SchoolDepartmentBudgetVo schoolDepartmentBudget);

    /**
     * 批量删除科室预算填报
     *
     * @param ids 需要删除的科室预算填报主键集合
     * @return 结果
     */
    public int deleteSchoolDepartmentBudgetByIds(Long[] ids);

    /**
     * 删除科室预算填报信息
     *
     * @param id 科室预算填报主键
     * @return 结果
     */
    public int deleteSchoolDepartmentBudgetById(Long id);

    /**
     * 查询本单位科室预算填报列表
     * @param schoolDepartmentBudget
     * @return
     */
    List<SchoolDepartmentBudgetVo> selectSchoolDepartmentBudgetListDw(SchoolDepartmentBudget schoolDepartmentBudget);

    /**
     * 流程定义
     * @param schoolDepartmentBudget
     * @param userName
     * @param key
     * @param variables
     * @return
     */
    int submitApply(SchoolDepartmentBudget schoolDepartmentBudget, String userName, String key, Map<String, Object> variables);

    /**
     * 待办列表
     * @param key
     * @param entity
     * @param userId
     * @return
     */
    List<SchoolDepartmentBudgetVo> findTodoTasks(String key, SchoolDepartmentBudget entity, String userId);

    /**
     * 已办列表
     * @param key
     * @param entity
     * @param userId
     * @return
     */
    List<SchoolDepartmentBudgetVo> findDoneTasks(String key, SchoolDepartmentBudget entity, String userId);
}
