package yangtz.cs.liu.campus.service.schoolDcwj;

import java.util.List;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.schoolDcwj.SchoolDcwjRy;
import yangtz.cs.liu.campus.vo.schoolDcwj.DataCountVo;
import yangtz.cs.liu.campus.vo.schoolDcwj.DataTVo;
import yangtz.cs.liu.campus.vo.schoolDcwj.DcwjRyExportVo;
import yangtz.cs.liu.campus.vo.schoolDcwj.SchoolDcwjAnVo;

/**
 * 接收人Service接口
 *
 * @author wengxiulin
 * @date 2023-03-01
 */
public interface ISchoolDcwjRyService extends IService<SchoolDcwjRy>
{
    /**
     * 查询接收人
     *
     * @param id 接收人主键
     * @return 接收人
     */
    public SchoolDcwjRy selectSchoolDcwjRyById(Long id);

    /**
     * 查询接收人列表
     *
     * @param schoolDcwjRy 接收人
     * @return 接收人集合
     */
    public List<SchoolDcwjRy> selectSchoolDcwjRyList(SchoolDcwjRy schoolDcwjRy);

    /**
     * 新增接收人
     *
     * @param schoolDcwjRy 接收人
     * @return 结果
     */
    public int insertSchoolDcwjRy(SchoolDcwjRy schoolDcwjRy);

    /**
     * 修改接收人
     *
     * @param schoolDcwjRy 接收人
     * @return 结果
     */
    public int updateSchoolDcwjRy(SchoolDcwjRy schoolDcwjRy);

    /**
     * 批量删除接收人
     *
     * @param ids 需要删除的接收人主键集合
     * @return 结果
     */
    public int deleteSchoolDcwjRyByIds(Long[] ids);

    /**
     * 删除接收人信息
     *
     * @param id 接收人主键
     * @return 结果
     */
    public int deleteSchoolDcwjRyById(Long id);

    //问卷结果 - 内容获取
    public List<SchoolDcwjAnVo> getAnData(Long dcwjId,SchoolDcwjAnVo vo);

    //教务-问卷结果 - 内容获取
    public List<SchoolDcwjAnVo> getSenateAnData(Long dcwjId,SchoolDcwjAnVo vo);

    //班主任-问卷结果 - 内容获取
    public List<SchoolDcwjAnVo> getAnStudentData(Long dcwjId,SchoolDcwjAnVo vo,List<Long> studentIds);

    //问卷结果 - 导出内容获取
    public List<DcwjRyExportVo> getAnExportData(Long dcwjId, SchoolDcwjAnVo vo,int num);

    //教务-问卷结果-导出教师内容获取
    public List<DcwjRyExportVo> getAnExportTeacherData(Long dcwjId, SchoolDcwjAnVo vo,int num);

    //班主任-问卷结果 - 导出内容获取
    public List<DcwjRyExportVo> getHeaderExportData(Long dcwjId, SchoolDcwjAnVo vo,List<Long> studentIds);

    //级部-问卷结果-明细数据-详情
    public List<DataTVo> getDetails(Long id);

    //级部-问卷结果-统计
    public List<DataCountVo> getCount(Long id);

    //班主任-问卷结果-统计
    public List<DataCountVo> getHeaderCount(Long id,List<Long> studentIds);

    List<SchoolDcwjAnVo> getTeaAnData(Long dcwjId, SchoolDcwjAnVo vo);

    List<SchoolDcwjAnVo> getAnData1(Long dcwjId, SchoolDcwjAnVo vo);

    //批量新增接收人(家长)
    int batchInsertDcwjRyStudent(List<SchoolDcwjRy> schoolDcwjRyList);

}
