package yangtz.cs.liu.campus.service.repairs;

import java.util.List;
import yangtz.cs.liu.campus.domain.repairs.LogisticsRepairs;

/**
 * 后勤报修Service接口
 *
 * @author ruoyi
 * @date 2023-07-25
 */
public interface ILogisticsRepairsService
{
    /**
     * 查询后勤报修
     *
     * @param id 后勤报修主键
     * @return 后勤报修
     */
    public LogisticsRepairs selectLogisticsRepairsById(Long id);

    /**
     * 查询个人后勤报修列表
     *
     * @param logisticsRepairs 后勤报修
     * @return 后勤报修集合
     */
    public List<LogisticsRepairs> selectLogisticsRepairsList(LogisticsRepairs logisticsRepairs);

    /**
     * 新增后勤报修
     *
     * @param logisticsRepairs 后勤报修
     * @return 结果
     */
    public int insertLogisticsRepairs(LogisticsRepairs logisticsRepairs);

    /**
     * 新增后勤报修
     *
     * @param logisticsRepairs 后勤报修
     * @return 结果
     */
    public int insertRepairs(LogisticsRepairs logisticsRepairs);

    /**
     * 修改后勤报修
     *
     * @param logisticsRepairs 后勤报修
     * @return 结果
     */
    public int updateLogisticsRepairs(LogisticsRepairs logisticsRepairs);

    /**
     * 修改后勤报修
     *
     * @param logisticsRepairs 后勤报修
     * @return 结果
     */
    public int updateRepairs(LogisticsRepairs logisticsRepairs);

    /**
     * 批量删除后勤报修
     *
     * @param ids 需要删除的后勤报修主键集合
     * @return 结果
     */
    public int deleteLogisticsRepairsByIds(Long[] ids);

    /**
     * 删除后勤报修信息
     *
     * @param id 后勤报修主键
     * @return 结果
     */
    public int deleteLogisticsRepairsById(Long id);

    /**
     * 查询所有后勤报修信息
     * @param logisticsRepairs
     * @return
     */
    List<LogisticsRepairs> selectListAll(LogisticsRepairs logisticsRepairs);

    /**
     * 查询所有后勤报修信息
     * @param logisticsRepairs
     * @return
     */
    List<LogisticsRepairs> selectListRepairs(LogisticsRepairs logisticsRepairs);

    /**
     * 查看个人报修列表
     * @param userId
     * @param logisticsRepairs
     * @return
     */
    List<LogisticsRepairs> getList(Long userId, LogisticsRepairs logisticsRepairs);
}
