package yangtz.cs.liu.campus.service.patrol;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.patrol.SchoolPatrolDetails;

import java.util.List;
import java.util.Map;

/**
 * 课堂巡视得分细节Service层
 */
public interface ISchoolPatrolDetailsService extends IService<SchoolPatrolDetails> {

    /**
     * 查询课堂巡视得分细节
     *
     * @param schoolPatrolDetails
     * @return
     */
    List<SchoolPatrolDetails> queryList(SchoolPatrolDetails schoolPatrolDetails);

    int updateSchoolPatrolDetailsByIds(Long[] ids, Long patrolId, Long score);

    /**
     * 新增（课堂巡检打分规则明细到课堂巡视打分表）
     *
     * @param ruleId
     * @return
     */
    int addRuleDetails(Long ruleId, Long patrolId);
}
