package yangtz.cs.liu.campus.service.message;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.message.SchoolMessageParentsPushs;
import yangtz.cs.liu.campus.domain.message.SchoolMessagePush;
import yangtz.cs.liu.campus.vo.message.SchoolMessagePushExportVO;
import yangtz.cs.liu.wechat.vo.message.MessagePushVO;

import java.util.List;

public interface ISchoolMessagePushService extends IService<SchoolMessagePush> {

    /**
     * 查询消息列表
     * @param schoolMessagePush
     * @return
     */
    public List<SchoolMessagePush> queryList(SchoolMessagePush schoolMessagePush);

    public List<MessagePushVO> getList(MessagePushVO messagePushVO);

    //新增
    public int savePush(SchoolMessagePush schoolMessagePush);

    //修改
    public int editPush(SchoolMessagePush schoolMessagePush);

    //详情
    public SchoolMessagePushExportVO getInfo(Long id);

    //删除
    public int deletePush(List<Long> ids);

    /**
     * 查询微信教师消息列表
     * @param messagePushVO
     * @return
     */
    public List<MessagePushVO> teacherPushList(Long userId, MessagePushVO messagePushVO);

}
