package yangtz.cs.liu.campus.service.interest;

import java.util.List;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.interest.SchoolInterestClasses;
import yangtz.cs.liu.wechat.vo.interest.ClassInfoVO;
import yangtz.cs.liu.wechat.vo.interest.ClassVO;

/**
 * 兴趣班Service接口
 * 
 * @author ruoyi
 * @date 2022-10-04
 */
public interface ISchoolInterestClassesService extends IService<SchoolInterestClasses>
{
    /**
     * 查询兴趣班列表
     * 
     * @param schoolInterestClasses 兴趣班
     * @return 兴趣班集合
     */
    public List<SchoolInterestClasses> queryList(SchoolInterestClasses schoolInterestClasses);

    //删除兴趣班
    public int deleteList(List<Long> ids);

    /**
     * 查询家长端兴趣班列表
     *
     * @param schoolInterestClasses 兴趣班
     * @return 兴趣班集合
     */
    public List<ClassVO> queryAllClassesList(SchoolInterestClasses schoolInterestClasses);

    /**
     * 查询教师端兴趣班列表
     *
     * @param classVO 兴趣班
     * @return 兴趣班集合
     */
    public List<ClassVO> queryTeacherClassesList(ClassVO classVO);

    //兴趣班详情
    public ClassInfoVO getInfoById(Long id);

    //学生所参加的兴趣班列表
    public List<ClassVO> queryStuClassesList(SchoolInterestClasses schoolInterestClasses);
}
