package yangtz.cs.liu.campus.service.interest;

import java.util.List;

import com.baomidou.mybatisplus.extension.service.IService;
import org.springframework.web.bind.annotation.PathVariable;
import yangtz.cs.liu.campus.domain.interest.SchoolInterestClassesChild;
import yangtz.cs.liu.campus.domain.student.SchoolStudent;
import yangtz.cs.liu.campus.vo.interest.ChildVO;
import yangtz.cs.liu.campus.vo.interest.StudentVO;

/**
 * 兴趣班学生Service接口
 * 
 * @author ruoyi
 * @date 2022-10-09
 */
public interface ISchoolInterestClassesChildService extends IService<SchoolInterestClassesChild>
{
    /**
     * 查询兴趣班学生列表
     * 
     * @param schoolInterestClassesChild 兴趣班学生
     * @return 兴趣班学生集合
     */
    public List<ChildVO> queryList(SchoolInterestClassesChild schoolInterestClassesChild, Long interestClassesId);

    /**
     * 新增兴趣班学生，挂载到兴趣班下
     */
    int addStudents(Long interestClassesId, List<Long> idList);

    /**
     * 查询兴趣班下所有的studentId
     */
    List<Long> selectAllStudentIdByInterestClassesId(Long interestClassesId);

    /**
     *新增弹框查询
     */
    List<SchoolStudent> selectAddList(SchoolStudent student , List<Long> studentIdList);

    /**
   导入学员
    */
    String importStudent(List<StudentVO> studentList, Long interestClassesId);

    /**
     * 微信学生报名
     */
    int addChild(Long interestClassesId);



}
