package yangtz.cs.liu.campus.service.impl.time;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.time.SchoolTime;
import yangtz.cs.liu.campus.domain.time.SchoolTimeRule;
import yangtz.cs.liu.campus.mapper.time.SchoolTimeMapper;
import yangtz.cs.liu.campus.service.time.ISchoolTimeService;
import java.util.List;
import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;

@Service
public class SchoolTimeServiceImpl extends ServiceImpl<SchoolTimeMapper, SchoolTime>implements ISchoolTimeService {

    @Autowired
    private SchoolTimeMapper schoolTimeMapper;

    @Override
    public List<SchoolTime> selectSchoolTimeList(SchoolTime schoolTime)
    {
        LambdaQueryWrapper<SchoolTime> lqw = new LambdaQueryWrapper<>();
        lqw
                .like(isNotBlank(schoolTime.getTimeName()),SchoolTime::getTimeName,schoolTime.getTimeName())
                .orderByAsc(SchoolTime::getCreateTime)
        ;
        return schoolTimeMapper.selectList(lqw);
    }

    @Override
    public List<SchoolTimeRule> selectRules() {
        List<SchoolTimeRule> list = schoolTimeMapper.selectRules();
        return list;
    }
}
