package yangtz.cs.liu.campus.service.impl.teacherFiles;

import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.mapper.SysDictDataMapper;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import yangtz.cs.liu.campus.domain.teacherFiles.SchoolTeacherBasicInformation;
import yangtz.cs.liu.campus.mapper.teacherFiles.SchoolTeacherBasichlnformationMapper;
import yangtz.cs.liu.campus.service.teacherFiles.SchoolTeacherBasichlnformationService;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

@Service
public class SchoolTeacherBasichlnformationServicelmpl extends ServiceImpl<SchoolTeacherBasichlnformationMapper, SchoolTeacherBasicInformation> implements SchoolTeacherBasichlnformationService
{

    @Autowired
    private  SchoolTeacherBasichlnformationMapper teacherBasichlnformationMapper;


    @Autowired
    private SysDictDataMapper dictDataMapper;
    @Override
    public List<SchoolTeacherBasicInformation> list(SchoolTeacherBasicInformation information) throws Exception {
        //出生日期查询条件转换
        this.symbolConversion(information);
        this.wordDateConversion(information);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        String format = sdf.format(new Date());
        List<SchoolTeacherBasicInformation> list = teacherBasichlnformationMapper.list(information);
        for (SchoolTeacherBasicInformation date :list){
            //1.计算年龄
            int ageFromIdCard = IdCardNumberUtils.getAgeFromIdCard(date.getIdCard());
            date.setAge(ageFromIdCard);
            //2.计算档案年龄
            if (null != date.getFileBirthDate()){
                int age = this.getAge(date.getFileBirthDate());
                date.setFileAge(age);
            }
            //3.到二中工作年限
            int gl = this.workAge(sdf.parse(format),date.getToSecondMiddleSchoolTime());
            date.setToSecondAge(gl);
        }
        return list;
    }




    @Override
    public SchoolTeacherBasicInformation getById(Long id) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        String format = sdf.format(new Date());
        SchoolTeacherBasicInformation schoolTeacherBasicInformation = teacherBasichlnformationMapper.selectById(id);
        //1.计算年龄
        int ageFromIdCard = IdCardNumberUtils.getAgeFromIdCard(schoolTeacherBasicInformation.getIdCard());
        schoolTeacherBasicInformation.setAge(ageFromIdCard);
        //2.计算档案年龄
        int age = this.getAge(schoolTeacherBasicInformation.getFileBirthDate());
        schoolTeacherBasicInformation.setFileAge(age);
        //3.到二中工作年限
        int nl = this.workAge(sdf.parse(format),schoolTeacherBasicInformation.getToSecondMiddleSchoolTime());
        schoolTeacherBasicInformation.setToSecondAge(nl);
        //4. 工作年龄
        if (null != schoolTeacherBasicInformation.getLengthOfServiceTime()){
            int gl = this.workAge(sdf.parse(format),schoolTeacherBasicInformation.getLengthOfServiceTime());
            schoolTeacherBasicInformation.setSeniority(gl);
        }
        return schoolTeacherBasicInformation;
    }


    /**
     * 导入
     * @param
     * @return
     */
    @Override
    public List<SchoolTeacherBasicInformation> importExcel(MultipartFile file) {
        List<SchoolTeacherBasicInformation> list = new ArrayList<>();
        try {
            XSSFWorkbook xwb = new XSSFWorkbook(file.getInputStream());//导入.xlxs
            //HSSFWorkbook hwb = new HSSFWorkbook(file.getInputStream());//导入.xls
            //获取第一个sheet表，下标是从0开始的
            XSSFSheet sheet = xwb.getSheetAt(0);
            int sheetNum = xwb.getNumberOfSheets();//获取总共有几个sheet表
            int rowNum = sheet.getLastRowNum();   //获取excel最后有数据的一行为n，返回n-1.返回数据行的下标 从0开始
            for (int i = 2; i <= rowNum; i++) {
                SchoolTeacherBasicInformation vo = new SchoolTeacherBasicInformation();
                XSSFRow row = sheet.getRow(i); //获取excel第i行，下标从0开始,第一行的下标为0
                //XSSFCell cell = row.getCell(0);//获取第i行的第一个单元格
                //名称
                if (row.getCell(1) != null) {
                    row.getCell(1).setCellType(CellType.STRING);//设置第i行第一个单元格数据为String类型
                    String name = row.getCell(1).getStringCellValue(); //获取第一个单元格的值
                    vo.setName(name);
                }
                //身份证
                if (row.getCell(2) != null) {
                    row.getCell(2).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(2).getStringCellValue();  //获取String类型的值
                    vo.setIdCard(shelterAddress);
                }
                //档案出生日期
                if (row.getCell(3) != null) {
                    //对于想要获取日期的值，可以把单元格设置为日期类型，但是如果直接设置为日期类型，表格中的数据不是日期类型，则会导致数据变为1970年或者其他不准确的年份
                    //先判断数据是否为日期类型
                    CellType type = row.getCell(3).getCellType();
                    //1为公式类型
                            row.getCell(3).setCellType(CellType.STRING);
                            String shelterAddress = row.getCell(3).getStringCellValue(); //获取日期类型的值
                            vo.setFileBirthDate(DateUtils.parseDate(shelterAddress));
                }
                //籍贯
                if (row.getCell(4) != null) {
                    row.getCell(4).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(4).getStringCellValue();  //获取String类型的值
                    vo.setHometown(shelterAddress);
                }
                //民族
                if (row.getCell(5) != null) {
                    row.getCell(5).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(5).getStringCellValue();  //获取String类型的值
                    vo.setNation(shelterAddress);
                }
                //政治面貌
                if (row.getCell(6) != null) {
                    row.getCell(6).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(6).getStringCellValue();  //获取String类型的值
                    String s = dictDataMapper.selectDictValue("politics_tatusls", shelterAddress);
                    vo.setPoliticalLandscape(s);
                }
                //入党时间
                if (row.getCell(7) != null) {
                    //对于想要获取日期的值，可以把单元格设置为日期类型，但是如果直接设置为日期类型，表格中的数据不是日期类型，则会导致数据变为1970年或者其他不准确的年份
                    //先判断数据是否为日期类型
                    //1为公式类型
                            row.getCell(7).setCellType(CellType.STRING);
                            String setDate = row.getCell(7).getStringCellValue(); //获取日期类型的值
                            vo.setPartyMembershipTime(DateUtils.parseDate(setDate));
                }

                //任教学科
                if (row.getCell(8) != null) {
                    row.getCell(8).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(8).getStringCellValue();  //获取String类型的值
                    String s = dictDataMapper.selectDictValue("teaching_subjects", shelterAddress);
                    vo.setTeachingSubject(s);
                }
                //钉钉手机号
                if (row.getCell(9) != null) {
                    row.getCell(9).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(9).getStringCellValue();  //获取String类型的值
                    vo.setDdPhone(shelterAddress);
                }
                //现职称
                if (row.getCell(10) != null) {
                    row.getCell(10).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(10).getStringCellValue();  //获取String类型的值
                    String s = dictDataMapper.selectDictValue("current_professional", shelterAddress);
                    vo.setCurrentProfessionalTitle(s);
                }
                //现职称获取资格时间 currentProfessionalTitleTime
                if (row.getCell(11) != null) {
                    //对于想要获取日期的值，可以把单元格设置为日期类型，但是如果直接设置为日期类型，表格中的数据不是日期类型，则会导致数据变为1970年或者其他不准确的年份
                    //先判断数据是否为日期类型
                    //1为公式类型
                            row.getCell(11).setCellType(CellType.STRING);
                            String setDate = row.getCell(11).getStringCellValue(); //获取日期类型的值
                            vo.setCurrentProfessionalTitleTime(DateUtils.parseDate(setDate));
                }
                //现聘职称
                if (row.getCell(12) != null) {
                    row.getCell(12).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(12).getStringCellValue();  //获取String类型的值
                    String s = dictDataMapper.selectDictValue("current_professional", shelterAddress);
                    vo.setCurrentHiringProfessionalTitle(s);
                }
                //现职称聘用时间 currentHiringProfessionalTitleTime
                if (row.getCell(13) != null) {
                    //对于想要获取日期的值，可以把单元格设置为日期类型，但是如果直接设置为日期类型，表格中的数据不是日期类型，则会导致数据变为1970年或者其他不准确的年份
                    //先判断数据是否为日期类型
                    CellType type = row.getCell(13).getCellType();
                    //1为公式类型
                            row.getCell(13).setCellType(CellType.STRING);
                            String setDate = row.getCell(13).getStringCellValue(); //获取日期类型的值
                            vo.setCurrentHiringProfessionalTitleTime(DateUtils.parseDate(setDate));
                }

                //现聘岗位
                if (row.getCell(14) != null) {
                    row.getCell(14).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(14).getStringCellValue();  //获取String类型的值
                    String s = dictDataMapper.selectDictValue("current_position", shelterAddress);
                    vo.setCurrentJobLevel(s);
                }



                //现岗位等级
                if (row.getCell(15) != null) {
                    row.getCell(15).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(15).getStringCellValue();  //获取String类型的值
                    String s = dictDataMapper.selectDictValue("current_joblevel", shelterAddress);
                    vo.setCurrentJobLevel(s);
                }
                //现岗位聘用时间 currentJobLevelAppointmentTime
                if (row.getCell(16) != null) {
                    //对于想要获取日期的值，可以把单元格设置为日期类型，但是如果直接设置为日期类型，表格中的数据不是日期类型，则会导致数据变为1970年或者其他不准确的年份
                    //先判断数据是否为日期类型
                    //1为公式类型
                            row.getCell(16).setCellType(CellType.STRING);
                            String setDate = row.getCell(16).getStringCellValue(); //获取日期类型的值
                            vo.setCurrentJobLevelAppointmentTime(DateUtils.parseDate(setDate));
                }
                //职务
                if (row.getCell(17) != null) {
                    row.getCell(17).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(17).getStringCellValue();  //获取String类型的值
                    vo.setDuties(shelterAddress);
                }
                //教师资格种类
                if (row.getCell(18) != null) {
                    row.getCell(18).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(18).getStringCellValue();  //获取String类型的值
                    vo.setTeacherQualificationType(shelterAddress);
                }
                //教师资格证号码
                if (row.getCell(19) != null) {
                    row.getCell(19).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(19).getStringCellValue();  //获取String类型的值
                    vo.setTeacherQualificationCertificateNum(shelterAddress);
                }
                //参加工作时间
                if (row.getCell(20) != null) {
                    row.getCell(20).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(20).getStringCellValue();  //获取String类型的值
                    vo.setWorkingHours(shelterAddress);
                }
                //到二中工作时间
                if (row.getCell(21) != null) {
                    //对于想要获取日期的值，可以把单元格设置为日期类型，但是如果直接设置为日期类型，表格中的数据不是日期类型，则会导致数据变为1970年或者其他不准确的年份
                    //先判断数据是否为日期类型
                    //1为公式类型
                            row.getCell(21).setCellType(CellType.STRING);
                            String setDate = row.getCell(21).getStringCellValue(); //获取日期类型的值
                            vo.setToSecondMiddleSchoolTime(DateUtils.parseDate(setDate));
                }
                //在岗情况
                if (row.getCell(22) != null) {
                    row.getCell(22).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(22).getStringCellValue();  //获取String类型的值
                    String s = dictDataMapper.selectDictValue("duty_situation", shelterAddress);
                    vo.setCurrentJobLevel(s);
                }
                //在编情况
                if (row.getCell(23) != null) {
                    row.getCell(23).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(23).getStringCellValue();  //获取String类型的值
                    String s = dictDataMapper.selectDictValue("current_situation", shelterAddress);
                    vo.setCurrentJobLevel(s);
                }

                //毕业学院1
                if (row.getCell(24) != null) {
                    row.getCell(24).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(24).getStringCellValue();  //获取String类型的值
                    vo.setGraduationInstitution1(shelterAddress);
                }
                //专业1
                if (row.getCell(25) != null) {
                    row.getCell(25).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(25).getStringCellValue();  //获取String类型的值
                    vo.setMajor1(shelterAddress);
                }
                //毕业时间1
                if (row.getCell(26) != null) {
                    //对于想要获取日期的值，可以把单元格设置为日期类型，但是如果直接设置为日期类型，表格中的数据不是日期类型，则会导致数据变为1970年或者其他不准确的年份
                    //先判断数据是否为日期类型
                    //1为公式类型
                            row.getCell(26).setCellType(CellType.STRING);
                            String setDate = row.getCell(26).getStringCellValue(); //获取日期类型的值
                            vo.setGraduationTime1(DateUtils.parseDate(setDate));
                }
                //毕业学院2
                if (row.getCell(27) != null) {
                    row.getCell(27).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(27).getStringCellValue();  //获取String类型的值
                    vo.setGraduationInstitution2(shelterAddress);
                }
                //专业2
                if (row.getCell(28) != null) {
                    row.getCell(28).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(28).getStringCellValue();  //获取String类型的值
                    vo.setMajor2(shelterAddress);
                }
                //毕业时间2
                if (row.getCell(29) != null) {
                    //对于想要获取日期的值，可以把单元格设置为日期类型，但是如果直接设置为日期类型，表格中的数据不是日期类型，则会导致数据变为1970年或者其他不准确的年份
                    //先判断数据是否为日期类型
                    //1为公式类型
                            row.getCell(29).setCellType(CellType.STRING);
                            String setDate = row.getCell(29).getStringCellValue(); //获取日期类型的值
                            vo.setGraduationTime2(DateUtils.parseDate(setDate));
                }

                //毕业学院3
                if (row.getCell(30) != null) {
                    row.getCell(30).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(30).getStringCellValue();  //获取String类型的值
                    vo.setGraduationInstitution3(shelterAddress);
                }
                //专业3
                if (row.getCell(31) != null) {
                    row.getCell(31).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(31).getStringCellValue();  //获取String类型的值
                    vo.setMajor3(shelterAddress);
                }
                //毕业时间3
                if (row.getCell(32) != null) {
                    //对于想要获取日期的值，可以把单元格设置为日期类型，但是如果直接设置为日期类型，表格中的数据不是日期类型，则会导致数据变为1970年或者其他不准确的年份
                    //先判断数据是否为日期类型
                    //1为公式类型

                            row.getCell(32).setCellType(CellType.STRING);
                            String setDate = row.getCell(32).getStringCellValue(); //获取日期类型的值
                            vo.setGraduationTime3(DateUtils.parseDate(setDate));
                }
                //第一学历
                if (row.getCell(33) != null) {
                    row.getCell(33).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(33).getStringCellValue();  //获取String类型的值
                    vo.setFirstDegree(shelterAddress);
                }

                //最后学历
                if (row.getCell(34) != null) {
                    row.getCell(34).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(34).getStringCellValue();  //获取String类型的值
                    vo.setLastDegree(shelterAddress);
                }
                //学位
                if (row.getCell(35) != null) {
                    row.getCell(35).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(35).getStringCellValue();  //获取String类型的值
                    vo.setDegree(shelterAddress);
                }
                //工作经理
                if (row.getCell(36) != null) {
                    row.getCell(36).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(36).getStringCellValue();  //获取String类型的值
                    vo.setWorkExperience(shelterAddress);
                }
                //备注
                if (row.getCell(37) != null) {
                    row.getCell(37).setCellType(CellType.STRING);
                    String shelterAddress = row.getCell(37).getStringCellValue();  //获取String类型的值
                    vo.setRemark(shelterAddress);
                }
//                if (row.getCell(4) != null) {
//                    row.getCell(4).setCellType(CellType.NUMERIC);
//
//                    double capacity = row.getCell(4).getNumericCellValue();  //获取数值类型的值
//                    vo.setCapacity((int) capacity);
//                }
                list.add(vo);
            }

        } catch (IOException e) {
            e.printStackTrace();
            log.error(e.toString());
        } catch (IllegalStateException e) {
            e.printStackTrace();
            log.error(e.toString());
        } catch (Exception e) {
            e.printStackTrace();
            log.error(e.toString());
        }
        return list;

    }








    //计算年龄
    private int getAge(Date birth) {
        Calendar cal = Calendar.getInstance();
        int thisYear = cal.get(Calendar.YEAR);
        int thisMonth = cal.get(Calendar.MONTH);

        cal.setTime(birth);
        int birthYear = cal.get(Calendar.YEAR);
        int birthMonth = cal.get(Calendar.MONTH);

        int age = thisYear - birthYear;

        // 未足月
        if (thisMonth <= birthMonth) {
            // 当月
            if (thisMonth == birthMonth) {

            } else {
                age--;
            }
        }
        return age;
    }

    //计算工龄
    public int workAge(Date nowTime, Date workTime) throws ParseException{
        int year = 0;
//当前时间的年月日
        Calendar cal = Calendar.getInstance();
        cal.setTime(nowTime);
        int nowYear = cal.get(Calendar.YEAR);
        int nowMonth = cal.get(Calendar.MONTH);
        int nowDay = cal.get(Calendar.DAY_OF_MONTH);
//开始工作时间的年月日
        cal.setTime(workTime);
        int workYear = cal.get(Calendar.YEAR);
        int workMonth = cal.get(Calendar.MONTH);
        int workDay = cal.get(Calendar.DAY_OF_MONTH);
//得到工龄
        year = nowYear - workYear; //得到年差
//若目前月数少于开始工作时间的月数，年差-1
        if (nowMonth < workMonth){
            year = year - 1;
        }else if (nowMonth == workMonth){
//当月数相等时，判断日数，若当月的日数小于开始工作时间的日数，年差-1
            if (nowDay < workDay){
                year = year - 1;
            }
        }
        return year;
    }

    /**
     * 出生年月条件转换
     * @param information
     */
    private void symbolConversion(SchoolTeacherBasicInformation information){
        String birthDate = information.getBirthDate();
        if (StringUtils.isEmpty(birthDate)){
            return;
        } else if (birthDate.contains(">=")) {
            String substring = birthDate.substring(2, birthDate.length());
            information.setBirthDategtd(substring);
            information.setBirthDate(null);
        } else if (birthDate.contains("<=")) {
            String substring = birthDate.substring(2, birthDate.length());
            information.setBirthDateltd(substring);
            information.setBirthDate(null);
        } else if (birthDate.contains("<")) {
            String substring = birthDate.substring(1, birthDate.length());
            information.setBirthDatelt(substring);
            information.setBirthDate(null);
        } else if (birthDate.contains(">")) {
            String substring = birthDate.substring(1, birthDate.length());
            information.setBirthDategt(substring);
            information.setBirthDate(null);
        } else if (birthDate.contains("=")) {
            String substring = birthDate.substring(1, birthDate.length());
            information.setBirthDate(substring);
        }
    }
    /**
     * 参加工作调整
     */

    private void wordDateConversion(SchoolTeacherBasicInformation information){
        String workingHours = information.getWorkingHours();
        if (StringUtils.isEmpty(workingHours)){
            return;
        } else if (workingHours.contains(">=")) {
            String substring = workingHours.substring(2, workingHours.length());
            information.setWorkingHoursgtd(substring);
            information.setWorkingHours(null);
        } else if (workingHours.contains("<=")) {
            String substring = workingHours.substring(2, workingHours.length());
            information.setWorkingHoursltd(substring);
            information.setWorkingHours(null);
        } else if (workingHours.contains("<")) {
            String substring = workingHours.substring(1, workingHours.length());
            information.setWorkingHourslt(substring);
            information.setWorkingHours(null);
        } else if (workingHours.contains(">")) {
            String substring = workingHours.substring(1, workingHours.length());
            information.setWorkingHoursgt(substring);
            information.setWorkingHours(null);
        } else if (workingHours.contains("=")) {
            String substring = workingHours.substring(1, workingHours.length());
            information.setWorkingHours(substring);
        }



    }


}
