package yangtz.cs.liu.campus.service.impl.studentTurnover;

import java.util.List;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.studentTurnover.StudentTurnover;
import yangtz.cs.liu.campus.mapper.studentTurnover.StudentTurnoverMapper;
import yangtz.cs.liu.campus.service.studentTurnover.IStudentTurnoverService;
import yangtz.cs.liu.campus.vo.studentTurnover.TurnoverVo;


/**
 * 异动管理Service业务层处理
 *
 * @author wengxiulin
 * @date 2023-02-20
 */
@Service
public class StudentTurnoverServiceImpl extends ServiceImpl<StudentTurnoverMapper,StudentTurnover> implements IStudentTurnoverService
{
    @Autowired
    private StudentTurnoverMapper studentTurnoverMapper;

    /**
     * 查询异动管理
     *
     * @param id 异动管理主键
     * @return 异动管理
     */
    @Override
    public StudentTurnover selectStudentTurnoverById(Long id)
    {
        return studentTurnoverMapper.selectStudentTurnoverById(id);
    }

    /**
     * 查询异动管理列表
     *
     * @param studentTurnover 异动管理
     * @return 异动管理
     */
    @Override
    public List<StudentTurnover> selectStudentTurnoverList(StudentTurnover studentTurnover)
    {
        return studentTurnoverMapper.selectStudentTurnoverList(studentTurnover);
    }


    @Override
    public TurnoverVo queryInfo(Long id) {
        return studentTurnoverMapper.queryInfo(id);
    }

    /**
     * 新增异动管理
     *
     * @param studentTurnover 异动管理
     * @return 结果
     */
    @Override
    public int insertStudentTurnover(StudentTurnover studentTurnover)
    {
        studentTurnover.setCreateTime(DateUtils.getNowDate());
        return studentTurnoverMapper.insertStudentTurnover(studentTurnover);
    }

    /**
     * 修改异动管理
     *
     * @param studentTurnover 异动管理
     * @return 结果
     */
    @Override
    public int updateStudentTurnover(StudentTurnover studentTurnover)
    {
        studentTurnover.setUpdateTime(DateUtils.getNowDate());
        return studentTurnoverMapper.updateStudentTurnover(studentTurnover);
    }

    /**
     * 批量删除异动管理
     *
     * @param ids 需要删除的异动管理主键
     * @return 结果
     */
    @Override
    public int deleteStudentTurnoverByIds(Long[] ids)
    {
        return studentTurnoverMapper.deleteStudentTurnoverByIds(ids);
    }

    /**
     * 删除异动管理信息
     *
     * @param id 异动管理主键
     * @return 结果
     */
    @Override
    public int deleteStudentTurnoverById(Long id)
    {
        return studentTurnoverMapper.deleteStudentTurnoverById(id);
    }
}
