package yangtz.cs.liu.campus.service.impl.student;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.student.SchoolEducation;
import yangtz.cs.liu.campus.mapper.student.SchoolEducationMapper;
import yangtz.cs.liu.campus.service.student.ISchoolEducationService;

import java.util.List;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;

@Service
public class SchoolEducationService extends ServiceImpl<SchoolEducationMapper, SchoolEducation> implements ISchoolEducationService {

    @Autowired
    private SchoolEducationMapper schoolEducationMapper;

    @Override
    public List<SchoolEducation> queryList(SchoolEducation schoolEducation) {
        LambdaQueryWrapper<SchoolEducation> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(SchoolEducation::getStudentId, schoolEducation.getStudentId())
                .eq(isNotNull(schoolEducation.getPatrolDate()),SchoolEducation::getPatrolDate,schoolEducation.getPatrolDate())
        ;
//        return schoolEducationMapper.queryList(schoolEducation);
        return schoolEducationMapper.selectList(lqw);
    }
}
