package yangtz.cs.liu.campus.service.impl.student;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.student.SchoolEducationRule;
import yangtz.cs.liu.campus.mapper.student.SchoolEducationRuleMapper;
import yangtz.cs.liu.campus.service.student.ISchoolEducationRuleService;

import java.util.List;

@Service
public class SchoolEducationRuleServiceImpl extends ServiceImpl<SchoolEducationRuleMapper, SchoolEducationRule> implements ISchoolEducationRuleService {

    @Autowired
    private SchoolEducationRuleMapper schoolEducationRuleMapper;

    /**
     * 学校德育检查打分规则 列表
     *
     * @param schoolEducationRule
     * @return
     */
    @Override
    public List<SchoolEducationRule> queryList(SchoolEducationRule schoolEducationRule) {
        LambdaQueryWrapper<SchoolEducationRule> lqw = new LambdaQueryWrapper<>();
        lqw
                .like(StringUtils.isNotEmpty(schoolEducationRule.getContentType()), SchoolEducationRule::getContentType, schoolEducationRule.getContentType())
                .orderByAsc(SchoolEducationRule::getSort)
        ;
        return schoolEducationRuleMapper.selectList(lqw);
    }
}
