package yangtz.cs.liu.campus.service.impl.schoolexam;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.exception.base.BaseException;
import com.ruoyi.common.utils.StringUtils;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolexam.SchoolExam;
import yangtz.cs.liu.campus.domain.schoolexam.SchoolExamDetail;
import yangtz.cs.liu.campus.mapper.schoolexam.SchoolExamDetailMapper;
import yangtz.cs.liu.campus.service.schoolexam.ISchoolExamDetailService;

import java.util.List;

import static cn.hutool.core.util.ObjectUtil.isNotNull;
import static cn.hutool.core.util.ObjectUtil.isNull;
import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;

/**
 * 学校考试信息细节业务层
 */
@Service
public class SchoolExamDetailServiceImpl extends ServiceImpl<SchoolExamDetailMapper, SchoolExamDetail> implements ISchoolExamDetailService {
    @Autowired
    private SchoolExamDetailMapper schoolExamDetailMapper;


    @Override
    public List<SchoolExamDetail> queryList(SchoolExamDetail schoolExamDetail) {
        LambdaQueryWrapper<SchoolExamDetail> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(isNotNull(schoolExamDetail.getExamId()),SchoolExamDetail::getExamId,schoolExamDetail.getExamId())
                .like(isNotBlank(schoolExamDetail.getStudentName()), SchoolExamDetail::getStudentName, schoolExamDetail.getStudentName())
                .orderByDesc(SchoolExamDetail::getCreateTime)
        ;
        List<SchoolExamDetail> list = schoolExamDetailMapper.selectList(lqw);
        return list;
    }


    @Override
    public String importExamDetail(List<SchoolExamDetail> list,Long examId) {
        //记录日志数据
        int successNum = 0;
        int failureNum = 0;
        StringBuilder successMsg = new StringBuilder();
        StringBuilder failureMsg = new StringBuilder();
        for (SchoolExamDetail schoolExamDetail : list) {
            try {
                schoolExamDetail.setExamId(examId);
                schoolExamDetailMapper.insert(schoolExamDetail);
            } catch (Exception e) {
                failureNum++;
                String msg = "<br>学生" + schoolExamDetail.getStudentName() + "导入失败";
                failureMsg.append(msg + e.getMessage());
                throw new ServiceException("导入失败");
            }
        }
        if (failureNum > 0) {
            failureMsg.insert(0, "很抱歉，导入失败！共" + failureNum + "条数据格式不正确，错误如下：");
            throw new ServiceException(failureMsg.toString());
        } else {
            successMsg.insert(0, "恭喜您，数据已全部导入成功！共 " + successNum + "条，数据如下：");
        }
        return successMsg.toString();
    }

    @Override
    public void check(List<SchoolExamDetail> list, Long examId) {
        //是否为空
        if(StringUtils.isNull(list) || list.size() == 0){
            throw new ServiceException("导入数据不能为空");
        }
        //记录日志数据
        int failureNum = 0;
        StringBuilder failureMsg = new StringBuilder();
        for(SchoolExamDetail schoolExamDetail : list){
            schoolExamDetail.setExamId(examId);
            if(schoolExamDetail.getStudentName() == null || StringUtils.isEmpty(schoolExamDetail.getStudentName())){
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、学生姓名不能为空，请您重新输入！");
            }else if(schoolExamDetail.getIdCard() == null || StringUtils.isNull(schoolExamDetail.getIdCard())){
                failureNum++;
                failureMsg.append("<br/>" + failureNum + "、学生身份证号不能为空，请您重新输入！");
            }else {
                LambdaQueryWrapper<SchoolExamDetail> lqw = new LambdaQueryWrapper<>();
                lqw
                        .eq(SchoolExamDetail::getExamId, examId)
                        .eq(SchoolExamDetail::getIdCard, schoolExamDetail.getIdCard());
                SchoolExamDetail examDetail = schoolExamDetailMapper.selectOne(lqw);
                if (isNotNull(examDetail)){
                    failureNum++;
                    failureMsg.append("<br/>" + failureNum + "、该学生成绩已存在，请您重新检查！");
                }
            }
        }
    }
}
