package yangtz.cs.liu.campus.service.impl.schoolStudio;

import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import yangtz.cs.liu.campus.domain.schoolStudio.SchoolStudioAppointment;
import yangtz.cs.liu.campus.domain.schoolStudio.SchoolStudioUse;
import yangtz.cs.liu.campus.mapper.schoolStudio.SchoolStudioAppointmentMapper;
import yangtz.cs.liu.campus.mapper.schoolStudio.SchoolStudioUseMapper;
import yangtz.cs.liu.campus.service.schoolStudio.ISchoolStudioAppointmentService;

import java.util.List;

/**
 * 录播室预约情况Service业务层处理
 *
 * @author ruoyi
 * @date 2023-07-10
 */
@Service
public class SchoolStudioAppointmentServiceImpl implements ISchoolStudioAppointmentService
{
    @Autowired
    private SchoolStudioAppointmentMapper schoolStudioAppointmentMapper;
    @Autowired
    private SchoolStudioUseMapper schoolStudioUseMapper;

    /**
     * 查询录播室预约情况
     *
     * @param id 录播室预约情况主键
     * @return 录播室预约情况
     */
    @Override
    public SchoolStudioAppointment selectSchoolStudioAppointmentById(Long id)
    {
        SchoolStudioAppointment schoolStudioAppointment = schoolStudioAppointmentMapper.selectSchoolStudioAppointmentById(id);
        if (StringUtils.isNotNull(schoolStudioAppointment)){
            schoolStudioAppointment.setAppointmentJc("第" + schoolStudioAppointment.getAppointmentJc() + "节");
        }
        return schoolStudioAppointment;
    }

    /**
     * 查询全部录播室预约情况列表
     *
     * @param schoolStudioAppointment 录播室预约情况
     * @return 录播室预约情况
     */
    @Override
    public List<SchoolStudioAppointment> selectSchoolStudioAppointmentList(SchoolStudioAppointment schoolStudioAppointment)
    {
        List<SchoolStudioAppointment> list = schoolStudioAppointmentMapper.selectSchoolStudioAppointmentList(schoolStudioAppointment);
        if (list.size() > 0){
            for (SchoolStudioAppointment studioAppointment : list) {
                studioAppointment.setAppointmentJc("第" + studioAppointment.getAppointmentJc() + "节");
            }
        }
        return list;
    }

    /**
     * 查询个人录播室预约情况列表
     * @param schoolStudioAppointment
     * @return
     */
    @Override
    public List<SchoolStudioAppointment> selectSchoolStudioAppointmentListGr(SchoolStudioAppointment schoolStudioAppointment) {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        schoolStudioAppointment.setAppointmentUserId(user.getUserId());
        List<SchoolStudioAppointment> list = schoolStudioAppointmentMapper.selectSchoolStudioAppointmentList(schoolStudioAppointment);
        if (list.size() > 0){
            for (SchoolStudioAppointment studioAppointment : list) {
                studioAppointment.setAppointmentJc("第" + studioAppointment.getAppointmentJc() + "节");
            }
        }
        return list;
    }

    /**
     * 新增录播室预约
     *
     * @param schoolStudioAppointment 录播室预约情况
     * @return 结果
     */
    @Override
    @Transactional
    public int insertSchoolStudioAppointment(SchoolStudioAppointment schoolStudioAppointment)
    {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //设置预约人
        schoolStudioAppointment.setAppointmentUserId(user.getUserId());
        schoolStudioAppointment.setAppointmentUserName(user.getUserName());
        //设置申请时间
        schoolStudioAppointment.setApplyTime(DateUtils.getNowDate());
        //设置预约状态
        schoolStudioAppointment.setStatu("1");
        int rows = schoolStudioAppointmentMapper.insertSchoolStudioAppointment(schoolStudioAppointment);
        insertSchoolStudioUse(schoolStudioAppointment);
        return rows;
    }

    /**
     * 新增录播室使用情况
     * @param schoolStudioAppointment
     */
    private void insertSchoolStudioUse(SchoolStudioAppointment schoolStudioAppointment)
    {
        Long appId = schoolStudioAppointment.getId();
        String[] split = schoolStudioAppointment.getAppointmentJc().split(",");
        for (String s : split) {
            SchoolStudioUse schoolStudioUse = new SchoolStudioUse();
            schoolStudioUse.setAppointmentId(appId);
            schoolStudioUse.setStudioId(schoolStudioAppointment.getStudioId());
            schoolStudioUse.setUseDate(schoolStudioAppointment.getAppointmentTime());
            schoolStudioUse.setUseJc(s);
            schoolStudioUse.setUseUserId(schoolStudioAppointment.getAppointmentUserId());
            schoolStudioUse.setUseUserName(schoolStudioAppointment.getAppointmentUserName());
            //新增录播室使用
            schoolStudioUseMapper.insertSchoolStudioUse(schoolStudioUse);
        }
    }

    /**
     * 取消录播室预约
     *
     * @param schoolStudioAppointment 录播室预约情况
     * @return 结果
     */
    @Override
    @Transactional
    public int updateSchoolStudioAppointment(SchoolStudioAppointment schoolStudioAppointment)
    {
        //取消预约对应录播室使用情况
        schoolStudioUseMapper.deleteSchoolStudioUseByAppId(schoolStudioAppointment.getId());
        return schoolStudioAppointmentMapper.updateSchoolStudioAppointment(schoolStudioAppointment);
    }

//    /**
//     * 批量删除录播室预约情况
//     *
//     * @param ids 需要删除的录播室预约情况主键
//     * @return 结果
//     */
//    @Override
//    public int deleteSchoolStudioAppointmentByIds(Long[] ids)
//    {
//        return schoolStudioAppointmentMapper.deleteSchoolStudioAppointmentByIds(ids);
//    }
//
//    /**
//     * 删除录播室预约情况信息
//     *
//     * @param id 录播室预约情况主键
//     * @return 结果
//     */
//    @Override
//    public int deleteSchoolStudioAppointmentById(Long id)
//    {
//        return schoolStudioAppointmentMapper.deleteSchoolStudioAppointmentById(id);
//    }
}
