package yangtz.cs.liu.campus.service.impl.schoolSecurity;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolSecurity.SchoolVideoConsult;
import yangtz.cs.liu.campus.mapper.schoolSecurity.SchoolVideoConsultMapper;
import yangtz.cs.liu.campus.service.schoolSecurity.ISchoolVideoConsultService;
import yangtz.cs.liu.campus.vo.schoolSecurity.SchoolVideoConsultVo;

import java.util.List;

/**
 * 监控录像调用(内部)Service业务层处理
 *
 * @author ruoyi
 * @date 2023-09-11
 */
@Service
public class SchoolVideoConsultServiceImpl extends ServiceImpl<SchoolVideoConsultMapper,SchoolVideoConsult> implements ISchoolVideoConsultService
{

    @Autowired
    private SchoolVideoConsultMapper schoolVideoConsultMapper;

    /**
     * 查询监控录像调用(内部)
     *
     * @param id 监控录像调用(内部)主键
     * @return 监控录像调用(内部)
     */
    @Override
    public SchoolVideoConsultVo selectSchoolVideoConsultById(Long id)
    {
        return schoolVideoConsultMapper.selectSchoolVideoConsultById(id);
    }

    /**
     * 查询监控录像调用(内部)列表
     *
     * @param schoolVideoConsultVo 监控录像调用(内部)
     * @return 监控录像调用(内部)
     */
    @Override
    public List<SchoolVideoConsultVo> selectSchoolVideoConsultList(SchoolVideoConsultVo schoolVideoConsultVo)
    {
        return schoolVideoConsultMapper.selectSchoolVideoConsultList(schoolVideoConsultVo);
    }

    /**
     * 新增监控录像调用(内部)
     *
     * @param schoolVideoConsultVo 监控录像调用(内部)
     * @return 结果
     */
    @Override
    public int insertSchoolVideoConsult(SchoolVideoConsultVo schoolVideoConsultVo)
    {
        schoolVideoConsultVo.setCreateTime(DateUtils.getNowDate());
        return schoolVideoConsultMapper.insertSchoolVideoConsult(schoolVideoConsultVo);
    }

    /**
     * 修改监控录像调用(内部)
     *
     * @param schoolVideoConsultVo 监控录像调用(内部)
     * @return 结果
     */
    @Override
    public int updateSchoolVideoConsult(SchoolVideoConsultVo schoolVideoConsultVo)
    {
        schoolVideoConsultVo.setUpdateTime(DateUtils.getNowDate());
        return schoolVideoConsultMapper.updateSchoolVideoConsult(schoolVideoConsultVo);
    }

    /**
     * 批量删除监控录像调用(内部)
     *
     * @param ids 需要删除的监控录像调用(内部)主键
     * @return 结果
     */
    @Override
    public int deleteSchoolVideoConsultByIds(Long[] ids)
    {
        return schoolVideoConsultMapper.deleteSchoolVideoConsultByIds(ids);
    }

    /**
     * 删除监控录像调用(内部)信息
     *
     * @param id 监控录像调用(内部)主键
     * @return 结果
     */
    @Override
    public int deleteSchoolVideoConsultById(Long id)
    {
        return schoolVideoConsultMapper.deleteSchoolVideoConsultById(id);
    }
}
