package yangtz.cs.liu.campus.service.impl.schoolSecurity;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;
import yangtz.cs.liu.campus.domain.schoolSecurity.SchoolVideoConsultExternal;
import yangtz.cs.liu.campus.mapper.schoolSecurity.SchoolVideoConsultExternalMapper;
import yangtz.cs.liu.campus.service.schoolSecurity.ISchoolVideoConsultExternalService;
import yangtz.cs.liu.campus.vo.schoolSecurity.SchoolVideoConsultExternalVo;

import java.util.ArrayList;
import java.util.List;

/**
 * 监控调阅（外部）Service业务层处理
 *
 * @author ruoyi
 * @date 2023-09-11
 */
@Service
public class SchoolVideoConsultExternalServiceImpl extends ServiceImpl<SchoolVideoConsultExternalMapper,SchoolVideoConsultExternal> implements ISchoolVideoConsultExternalService
{

    @Autowired
    private SchoolVideoConsultExternalMapper schoolVideoConsultExternalMapper;

    /**
     * 查询监控调阅（外部）
     *
     * @param id 监控调阅（外部）主键
     * @return 监控调阅（外部）
     */
    @Override
    public SchoolVideoConsultExternalVo selectSchoolVideoConsultExternalById(Long id)
    {
        return schoolVideoConsultExternalMapper.selectSchoolVideoConsultExternalById(id);
    }

    /**
     * 查询监控调阅（外部）列表
     *
     * @param schoolVideoConsultExternalVo 监控调阅（外部）
     * @return 监控调阅（外部）
     */
    @Override
    public List<SchoolVideoConsultExternalVo> selectSchoolVideoConsultExternalList(SchoolVideoConsultExternalVo schoolVideoConsultExternalVo)
    {
        return schoolVideoConsultExternalMapper.selectSchoolVideoConsultExternalList(schoolVideoConsultExternalVo);
    }

    /**
     * 新增监控调阅（外部）
     *
     * @param schoolVideoConsultExternalVo 监控调阅（外部）
     * @return 结果
     */
    @Transactional
    @Override
    public int insertSchoolVideoConsultExternal(SchoolVideoConsultExternalVo schoolVideoConsultExternalVo)
    {
        schoolVideoConsultExternalVo.setCreateTime(DateUtils.getNowDate());
        int rows = schoolVideoConsultExternalMapper.insertSchoolVideoConsultExternal(schoolVideoConsultExternalVo);
        insertSchoolAccessory(schoolVideoConsultExternalVo);
        return rows;
    }

    /**
     * 修改监控调阅（外部）
     *
     * @param schoolVideoConsultExternalVo 监控调阅（外部）
     * @return 结果
     */
    @Transactional
    @Override
    public int updateSchoolVideoConsultExternal(SchoolVideoConsultExternalVo schoolVideoConsultExternalVo)
    {
        schoolVideoConsultExternalVo.setUpdateTime(DateUtils.getNowDate());
        schoolVideoConsultExternalMapper.deleteSchoolAccessoryByBusinessId(schoolVideoConsultExternalVo.getId());
        insertSchoolAccessory(schoolVideoConsultExternalVo);
        return schoolVideoConsultExternalMapper.updateSchoolVideoConsultExternal(schoolVideoConsultExternalVo);
    }

    /**
     * 批量删除监控调阅（外部）
     *
     * @param ids 需要删除的监控调阅（外部）主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteSchoolVideoConsultExternalByIds(Long[] ids)
    {
        schoolVideoConsultExternalMapper.deleteSchoolAccessoryByBusinessIds(ids);
        return schoolVideoConsultExternalMapper.deleteSchoolVideoConsultExternalByIds(ids);
    }

    /**
     * 删除监控调阅（外部）信息
     *
     * @param id 监控调阅（外部）主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteSchoolVideoConsultExternalById(Long id)
    {
        schoolVideoConsultExternalMapper.deleteSchoolAccessoryByBusinessId(id);
        return schoolVideoConsultExternalMapper.deleteSchoolVideoConsultExternalById(id);
    }

    /**
     * 新增附件信息信息
     *
     * @param schoolVideoConsultExternalVo 监控调阅（外部）对象
     */
    public void insertSchoolAccessory(SchoolVideoConsultExternalVo schoolVideoConsultExternalVo)
    {
        List<SchoolAccessory> schoolAccessoryList = schoolVideoConsultExternalVo.getSchoolAccessoryList();
        Long id = schoolVideoConsultExternalVo.getId();
        if (StringUtils.isNotNull(schoolAccessoryList))
        {
            List<SchoolAccessory> list = new ArrayList<SchoolAccessory>();
            for (SchoolAccessory schoolAccessory : schoolAccessoryList)
            {
                schoolAccessory.setBusinessId(id);
                list.add(schoolAccessory);
            }
            if (list.size() > 0)
            {
                schoolVideoConsultExternalMapper.batchSchoolAccessory(list);
            }
        }
    }
}
