package yangtz.cs.liu.campus.service.impl.schoolSecurity;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolSecurity.SchoolVehicleInOut;
import yangtz.cs.liu.campus.domain.schoolSecurity.SchoolVehicleRegistration;
import yangtz.cs.liu.campus.mapper.schoolSecurity.SchoolVehicleInOutMapper;
import yangtz.cs.liu.campus.mapper.schoolSecurity.SchoolVehicleRegistrationMapper;
import yangtz.cs.liu.campus.service.schoolSecurity.ISchoolVehicleInOutService;
import yangtz.cs.liu.campus.vo.schoolSecurity.SchoolVehicleInOutVo;

import java.util.List;
import java.util.Map;

/**
 * 车辆出入登记Service业务层处理
 *
 * @author ruoyi
 * @date 2023-09-11
 */
@Service
public class SchoolVehicleInOutServiceImpl extends ServiceImpl<SchoolVehicleInOutMapper,SchoolVehicleInOut> implements ISchoolVehicleInOutService
{

    @Autowired
    private SchoolVehicleInOutMapper schoolVehicleInOutMapper;
    @Autowired
    private SchoolVehicleRegistrationMapper schoolVehicleRegistrationMapper;

    /**
     * 查询车辆出入登记
     *
     * @param id 车辆出入登记主键
     * @return 车辆出入登记
     */
    @Override
    public SchoolVehicleInOutVo selectSchoolVehicleInOutById(Long id)
    {
        return schoolVehicleInOutMapper.selectSchoolVehicleInOutById(id);
    }

    /**
     * 查询车辆出入登记列表
     *
     * @param schoolVehicleInOutVo 车辆出入登记
     * @return 车辆出入登记
     */
    @Override
    public List<SchoolVehicleInOutVo> selectSchoolVehicleInOutList(SchoolVehicleInOutVo schoolVehicleInOutVo)
    {
        return schoolVehicleInOutMapper.selectSchoolVehicleInOutList(schoolVehicleInOutVo);
    }

    /**
     * 新增车辆出入登记
     *
     * @param schoolVehicleInOutVo 车辆出入登记
     * @return 结果
     */
    @Override
    public int insertSchoolVehicleInOut(SchoolVehicleInOutVo schoolVehicleInOutVo)
    {
        schoolVehicleInOutVo.setCreateTime(DateUtils.getNowDate());
        return schoolVehicleInOutMapper.insertSchoolVehicleInOut(schoolVehicleInOutVo);
    }

    /**
     * 修改车辆出入登记
     *
     * @param schoolVehicleInOutVo 车辆出入登记
     * @return 结果
     */
    @Override
    public int updateSchoolVehicleInOut(SchoolVehicleInOutVo schoolVehicleInOutVo)
    {
        schoolVehicleInOutVo.setUpdateTime(DateUtils.getNowDate());
        return schoolVehicleInOutMapper.updateSchoolVehicleInOut(schoolVehicleInOutVo);
    }

    /**
     * 批量删除车辆出入登记
     *
     * @param ids 需要删除的车辆出入登记主键
     * @return 结果
     */
    @Override
    public int deleteSchoolVehicleInOutByIds(Long[] ids)
    {
        return schoolVehicleInOutMapper.deleteSchoolVehicleInOutByIds(ids);
    }

    /**
     * 删除车辆出入登记信息
     *
     * @param id 车辆出入登记主键
     * @return 结果
     */
    @Override
    public int deleteSchoolVehicleInOutById(Long id)
    {
        return schoolVehicleInOutMapper.deleteSchoolVehicleInOutById(id);
    }

    /**
     * 获取当前登录人车辆登记信息
     * @param userId
     * @return
     */
    @Override
    public List<Map<String, String>> getUserVehicle(Long userId) {
        return schoolVehicleInOutMapper.getUserVehicle(userId);
    }

    /**
     * 新增车辆出入登记信息
     * @param schoolVehicleInOutVo
     * @return
     */
    @Override
    public int insertSchoolVehicleInOutVo(SchoolVehicleInOutVo schoolVehicleInOutVo) {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //判断是否选择级部/处室主任和分管领导
        if (StringUtils.isNull(schoolVehicleInOutVo.getHandUserId1())){
            throw new ServiceException("请选择级部/处室主任");
        }
        if (StringUtils.isNull(schoolVehicleInOutVo.getHandUserId2())){
            throw new ServiceException("请选择分管领导");
        }
        //判断已登记车牌号是否保留
        if (StringUtils.isNotEmpty(schoolVehicleInOutVo.getOldLicenseNumber())){
            if (schoolVehicleInOutVo.getIsRetain().equals("0")){
                //不保留，删除已登记车牌号
                LambdaQueryWrapper<SchoolVehicleRegistration> wrapper = new LambdaQueryWrapper<>();
                wrapper.eq(SchoolVehicleRegistration::getUserId,user.getUserId())
                        .eq(SchoolVehicleRegistration::getLicenseNumber,schoolVehicleInOutVo.getOldLicenseNumber());
                schoolVehicleRegistrationMapper.delete(wrapper);
            }
        }
        schoolVehicleInOutVo.setCreateBy(user.getUserName());
        return schoolVehicleInOutMapper.insertSchoolVehicleInOut(schoolVehicleInOutVo);
    }
}
