package yangtz.cs.liu.campus.service.impl.schoolRewardsPunishments;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolRewardsPunishments.SchoolScDiscipline;
import yangtz.cs.liu.campus.mapper.schoolRewardsPunishments.SchoolScDisciplineMapper;
import yangtz.cs.liu.campus.service.schoolRewardsPunishments.ISchoolScDisciplineService;

import java.util.List;
import java.util.Map;

/**
 * 学生违纪Service业务层处理
 *
 * @author ruoyi
 * @date 2023-11-06
 */
@Service
public class SchoolScDisciplineServiceImpl extends ServiceImpl<SchoolScDisciplineMapper,SchoolScDiscipline> implements ISchoolScDisciplineService
{
    @Autowired
    private SchoolScDisciplineMapper schoolScDisciplineMapper;

    /**
     * 查询学生违纪
     *
     * @param id 学生违纪主键
     * @return 学生违纪
     */
    @Override
    public SchoolScDiscipline selectSchoolScDisciplineById(Long id)
    {
        return schoolScDisciplineMapper.selectSchoolScDisciplineById(id);
    }

    /**
     * 查询学生违纪列表
     *
     * @param schoolScDiscipline 学生违纪
     * @return 学生违纪
     */
    @Override
    public List<SchoolScDiscipline> selectSchoolScDisciplineList(SchoolScDiscipline schoolScDiscipline)
    {
        return schoolScDisciplineMapper.selectSchoolScDisciplineList(schoolScDiscipline);
    }

    /**
     * 查询学生违纪列表(查看已通过)
     *
     * @param schoolScDiscipline 学生违纪
     * @return 学生违纪
     */
    @Override
    public List<SchoolScDiscipline> selectSchoolScDisciplineListTg(SchoolScDiscipline schoolScDiscipline)
    {
        return schoolScDisciplineMapper.selectSchoolScDisciplineListTg(schoolScDiscipline);
    }

    /**
     * 新增学生违纪
     *
     * @param schoolScDiscipline 学生违纪
     * @return 结果
     */
    @Override
    public int insertSchoolScDiscipline(SchoolScDiscipline schoolScDiscipline)
    {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        schoolScDiscipline.setApplyId(user.getUserId());
        schoolScDiscipline.setApplyName(user.getUserName());
        schoolScDiscipline.setApplyTime(DateUtils.getNowDate());
        schoolScDiscipline.setCreateBy(user.getUserName());
        schoolScDiscipline.setCreateTime(DateUtils.getNowDate());
        return schoolScDisciplineMapper.insertSchoolScDiscipline(schoolScDiscipline);
    }

    /**
     * 修改学生违纪
     *
     * @param schoolScDiscipline 学生违纪
     * @return 结果
     */
    @Override
    public int updateSchoolScDiscipline(SchoolScDiscipline schoolScDiscipline)
    {
        schoolScDiscipline.setUpdateBy(SecurityUtils.getUsername());
        schoolScDiscipline.setUpdateTime(DateUtils.getNowDate());
        return schoolScDisciplineMapper.updateSchoolScDiscipline(schoolScDiscipline);
    }

    /**
     * 批量删除学生违纪
     *
     * @param ids 需要删除的学生违纪主键
     * @return 结果
     */
    @Override
    public int deleteSchoolScDisciplineByIds(Long[] ids)
    {
        return schoolScDisciplineMapper.deleteSchoolScDisciplineByIds(ids);
    }

    /**
     * 删除学生违纪信息
     *
     * @param id 学生违纪主键
     * @return 结果
     */
    @Override
    public int deleteSchoolScDisciplineById(Long id)
    {
        return schoolScDisciplineMapper.deleteSchoolScDisciplineById(id);
    }

    /**
     * 获取最新三个年级
     * @return
     */
    @Override
    public List<Map<String, Object>> getGrade() {
        return schoolScDisciplineMapper.getGrade();
    }

    /**
     * 根据年级获取班级
     * @param gradeId
     * @return
     */
    @Override
    public List<Map<String, Object>> getClassList(Long gradeId) {
        return schoolScDisciplineMapper.getClassList(gradeId);
    }
}
