package yangtz.cs.liu.campus.service.impl.schoolLab;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolLabClassYearRelation;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolTeacherExperimentApplyLabs;
import yangtz.cs.liu.campus.mapper.schoolLab.SchoolTeacherExperimentApplyMapper;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolTeacherExperimentApply;
import yangtz.cs.liu.campus.mapper.schoolLab.SchoollTeacherExperimentApplyLabsMapper;
import yangtz.cs.liu.campus.service.schoolLab.ISchoolLabClassYearService;
import yangtz.cs.liu.campus.service.schoolLab.ISchoolTeacherExperimentApplyService;
import yangtz.cs.liu.campus.service.schoolLab.ISchoollTeacherExperimentApplyLabsService;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolLabClassYearVo;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolTeacherExperimentApplyVo;

/**
 * 教师个人实验申请Service业务层处理
 *
 * @author ruoyi
 * @date 2023-08-29
 */
@Service
public class SchoolTeacherExperimentApplyServiceImpl extends ServiceImpl<SchoolTeacherExperimentApplyMapper,SchoolTeacherExperimentApply> implements ISchoolTeacherExperimentApplyService
{
    @Autowired
    private SchoolTeacherExperimentApplyMapper schoolTeacherExperimentApplyMapper;
    @Autowired
    private ISchoollTeacherExperimentApplyLabsService schoollTeacherExperimentApplyLabsService;
    @Autowired
    private ISchoolLabClassYearService schoolLabClassYearService;
    /**
     * 查询教师个人实验申请
     *
     * @param id 教师个人实验申请主键
     * @return 教师个人实验申请
     */
    @Override
    public SchoolTeacherExperimentApplyVo selectSchoolTeacherExperimentApplyById(Long id)
    {
        SchoolTeacherExperimentApplyVo schoolTeacherExperimentApplyVo = schoolTeacherExperimentApplyMapper.selectSchoolTeacherExperimentApplyById(id);
        LambdaQueryWrapper<SchoolTeacherExperimentApplyLabs> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SchoolTeacherExperimentApplyLabs::getTeacherExperimentApplyId,schoolTeacherExperimentApplyVo.getId());
        List<SchoolTeacherExperimentApplyLabs> schoolTeacherExperimentApplyLabs = schoollTeacherExperimentApplyLabsService.list(wrapper);
        schoolTeacherExperimentApplyVo.setSchoolTeacherExperimentApplyLabsList(schoolTeacherExperimentApplyLabs);
        return schoolTeacherExperimentApplyVo;
    }

    /**
     * 查询教师个人实验申请列表
     *
     * @param schoolTeacherExperimentApplyVo 教师个人实验申请
     * @return 教师个人实验申请
     */
    @Override
    public List<SchoolTeacherExperimentApplyVo> selectSchoolTeacherExperimentApplyList(SchoolTeacherExperimentApplyVo schoolTeacherExperimentApplyVo)
    {
        List<SchoolTeacherExperimentApplyVo> schoolTeacherExperimentApplyVos = schoolTeacherExperimentApplyMapper.selectSchoolTeacherExperimentApplyList(schoolTeacherExperimentApplyVo);
        for ( SchoolTeacherExperimentApplyVo date : schoolTeacherExperimentApplyVos){
            LambdaQueryWrapper<SchoolTeacherExperimentApplyLabs> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(SchoolTeacherExperimentApplyLabs::getTeacherExperimentApplyId,date.getId());
            List<SchoolTeacherExperimentApplyLabs> schoolTeacherExperimentApplyLabs = schoollTeacherExperimentApplyLabsService.list(wrapper);
            date.setSchoolTeacherExperimentApplyLabsList(schoolTeacherExperimentApplyLabs);
        }
        return schoolTeacherExperimentApplyVos;
    }

    @Override
    public List<SchoolTeacherExperimentApplyVo> getTeacherList(SchoolTeacherExperimentApplyVo schoolTeacherExperimentApplyVo) {
        return schoolTeacherExperimentApplyMapper.getTeacherList(schoolTeacherExperimentApplyVo);
    }

    /**
     * 新增教师个人实验申请
     *
     * @param schoolTeacherExperimentApplyVo 教师个人实验申请
     * @return 结果
     */
    @Override
    public int insertSchoolTeacherExperimentApply(SchoolTeacherExperimentApplyVo schoolTeacherExperimentApplyVo)
    {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        schoolTeacherExperimentApplyVo.setApplyId(user.getUserId());
        schoolTeacherExperimentApplyVo.setApplyName(user.getUserName());
        schoolTeacherExperimentApplyVo.setApplyTime(DateUtils.getNowDate());
        schoolTeacherExperimentApplyVo.setCreateBy(user.getUserName());
        schoolTeacherExperimentApplyVo.setCreateTime(DateUtils.getNowDate());
        int rows = schoolTeacherExperimentApplyMapper.insertSchoolTeacherExperimentApply(schoolTeacherExperimentApplyVo);
        return rows;
    }

    /**
     * 修改教师个人实验申请
     *
     * @param schoolTeacherExperimentApplyVo 教师个人实验申请
     * @return 结果
     */
    @Override
    public int updateSchoolTeacherExperimentApply(SchoolTeacherExperimentApplyVo schoolTeacherExperimentApplyVo)
    {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        schoolTeacherExperimentApplyVo.setUpdateBy(user.getUserName());
        schoolTeacherExperimentApplyVo.setUpdateTime(DateUtils.getNowDate());
        return schoolTeacherExperimentApplyMapper.updateSchoolTeacherExperimentApply(schoolTeacherExperimentApplyVo);
    }

    /**
     * 批量删除教师个人实验申请
     *
     * @param ids 需要删除的教师个人实验申请主键
     * @return 结果
     */
    @Override
    public int deleteSchoolTeacherExperimentApplyByIds(Long[] ids)
    {
        return schoolTeacherExperimentApplyMapper.deleteSchoolTeacherExperimentApplyByIds(ids);
    }

    /**
     * 删除教师个人实验申请信息
     *
     * @param id 教师个人实验申请主键
     * @return 结果
     */
    @Override
    public int deleteSchoolTeacherExperimentApplyById(Long id)
    {
        return schoolTeacherExperimentApplyMapper.deleteSchoolTeacherExperimentApplyById(id);
    }

    /**
     * 实验室管理-教师个人演示实验审批-分配实验室
     * @param schoolTeacherExperimentApplyVo
     * @return
     */
    @Override
    public int teacherExperimentLabs(SchoolTeacherExperimentApplyVo schoolTeacherExperimentApplyVo) {
        List<SchoolTeacherExperimentApplyLabs> schoolTeacherExperimentApplyLabsList = schoolTeacherExperimentApplyVo.getSchoolTeacherExperimentApplyLabsList();
        Long id = schoolTeacherExperimentApplyVo.getId();
        if (StringUtils.isNull(schoolTeacherExperimentApplyLabsList)){
            throw new ServiceException("请选择实验室");
        }
        List<SchoolTeacherExperimentApplyLabs> list = new ArrayList<>();
        for (SchoolTeacherExperimentApplyLabs schoolTeacherExperimentApplyLabs : schoolTeacherExperimentApplyLabsList) {
            schoolTeacherExperimentApplyLabs.setTeacherExperimentApplyId(id);
            list.add(schoolTeacherExperimentApplyLabs);
        }
        if (list.size() > 0){
            schoolTeacherExperimentApplyMapper.deleteSchoolTeacherExperimentApplyLabsId(id);
            SchoolTeacherExperimentApplyVo schoolTeacherExperimentApplyVo1 = schoolTeacherExperimentApplyMapper.selectSchoolTeacherExperimentApplyById(id);
            //判断用户选择的实验室是否正在使用
            SchoolLabClassYearVo schoolLabClassYearVo1 = new SchoolLabClassYearVo();
            schoolLabClassYearVo1.setPlannedStartTime(schoolTeacherExperimentApplyVo1.getPlannedStartTime());
            schoolLabClassYearVo1.setPlannedEndTime(schoolTeacherExperimentApplyVo1.getPlannedEndTime());
            schoolLabClassYearVo1.setSub(schoolTeacherExperimentApplyVo1.getSub());
            List<Map<String, Object>> labList = schoolLabClassYearService.getLabList(schoolLabClassYearVo1);
            for (SchoolTeacherExperimentApplyLabs experimentApplyLabs : list) {
                for (Map<String, Object> map : labList) {
                    if (experimentApplyLabs.getLabId().equals(Long.parseLong(String.valueOf(map.get("labId"))))){
                        if ("使用中".equals(String.valueOf(map.get("useState")))){
                            throw new ServiceException("您选择的" + map.get("labName") + "实验室正在使用，请重新选择!");
                        }
                    }
                }
            }
            schoolTeacherExperimentApplyMapper.batchSchoolTeacherExperimentApplyLabs(list);
        }
        return schoolTeacherExperimentApplyMapper.updateSchoolTeacherExperimentApply(schoolTeacherExperimentApplyVo);
    }

    /**
     * 上传实验结果附件
     * @param schoolTeacherExperimentApplyVo
     * @return
     */
    @Override
    public int experimentResult(SchoolTeacherExperimentApplyVo schoolTeacherExperimentApplyVo) {
        //教师个人实验申请id
        Long id = schoolTeacherExperimentApplyVo.getId();
        //附件信息集合
        List<SchoolAccessory> schoolAccessoryList = schoolTeacherExperimentApplyVo.getSchoolAccessoryList();
        List<SchoolAccessory> list = new ArrayList<>();
        for (SchoolAccessory schoolAccessory : schoolAccessoryList) {
            schoolAccessory.setBusinessId(id);
            schoolAccessory.setModuleName("教师-教师个人实验申请");
            schoolAccessory.setAccessoryType("教师个人实验结果附件");
            schoolAccessory.setCreateBy(SecurityUtils.getLoginUser().getUser().getUserName());
            schoolAccessory.setCreateTime(DateUtils.getNowDate());
            list.add(schoolAccessory);
        }

        if (list.size() > 0){
            schoolTeacherExperimentApplyMapper.batchSchoolAccessory(list);
        }
        SchoolTeacherExperimentApply schoolTeacherExperimentApply = new SchoolTeacherExperimentApply();
        schoolTeacherExperimentApply.setId(id);
        schoolTeacherExperimentApply.setState("1");
        return schoolTeacherExperimentApplyMapper.updateById(schoolTeacherExperimentApply);
    }
}
