package yangtz.cs.liu.campus.service.impl.schoolLab;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;
import yangtz.cs.liu.campus.domain.award.Award;
import yangtz.cs.liu.campus.mapper.accessory.AccessoryMapper;
import yangtz.cs.liu.campus.mapper.schoolLab.SchoolLabCompetitionMapper;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolLabCompetition;
import yangtz.cs.liu.campus.service.schoolLab.ISchoolLabCompetitionService;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolLabCompetitionVo;

/**
 * 实验室竞赛Service业务层处理
 *
 * @author ruoyi
 * @date 2023-08-29
 */
@Service
public class SchoolLabCompetitionServiceImpl extends ServiceImpl<SchoolLabCompetitionMapper,SchoolLabCompetition> implements ISchoolLabCompetitionService
{
    @Autowired
    private SchoolLabCompetitionMapper schoolLabCompetitionMapper;
    @Autowired
    private AccessoryMapper accessoryMapper;

    /**
     * 查询实验室竞赛
     *
     * @param id 实验室竞赛主键
     * @return 实验室竞赛
     */
    @Override
    public SchoolLabCompetitionVo selectSchoolLabCompetitionById(Long id)
    {
        SchoolLabCompetitionVo schoolLabCompetitionVo = schoolLabCompetitionMapper.selectSchoolLabCompetitionById(id);
        LambdaQueryWrapper<SchoolAccessory> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SchoolAccessory::getBusinessId,schoolLabCompetitionVo.getId())
                .eq(SchoolAccessory::getAccessoryType,"证书照片");
        List<SchoolAccessory> schoolAccessories = accessoryMapper.selectList(wrapper);
        if (schoolAccessories.size() > 0){
            schoolLabCompetitionVo.setSchoolAccessoryList(schoolAccessories);
        }
        return schoolLabCompetitionVo;
    }

    /**
     * 查询实验室竞赛列表
     *
     * @param schoolLabCompetitionVo 实验室竞赛
     * @return 实验室竞赛
     */
    @Override
    public List<SchoolLabCompetitionVo> selectSchoolLabCompetitionList(SchoolLabCompetitionVo schoolLabCompetitionVo)
    {
        List<SchoolLabCompetitionVo> schoolLabCompetitionVos = schoolLabCompetitionMapper.selectSchoolLabCompetitionList(schoolLabCompetitionVo);
        for (SchoolLabCompetitionVo labCompetitionVo : schoolLabCompetitionVos) {
            LambdaQueryWrapper<SchoolAccessory> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(SchoolAccessory::getBusinessId,labCompetitionVo.getId())
                    .eq(SchoolAccessory::getAccessoryType,"证书照片");
            List<SchoolAccessory> schoolAccessories = accessoryMapper.selectList(wrapper);
            if (schoolAccessories.size() > 0){
                labCompetitionVo.setSchoolAccessoryList(schoolAccessories);
            }
        }
        return schoolLabCompetitionVos;
    }

    /**
     * 新增实验室竞赛
     *
     * @param schoolLabCompetitionVo 实验室竞赛
     * @return 结果
     */
    @Override
    @Transactional
    public int insertSchoolLabCompetition(SchoolLabCompetitionVo schoolLabCompetitionVo)
    {
        schoolLabCompetitionVo.setCreateBy(SecurityUtils.getLoginUser().getUser().getUserName());
        schoolLabCompetitionVo.setCreateTime(DateUtils.getNowDate());
        int rows = schoolLabCompetitionMapper.insertSchoolLabCompetition(schoolLabCompetitionVo);
        insertSchoolAccessory(schoolLabCompetitionVo);
        return rows;
    }

    /**
     * 修改实验室竞赛
     *
     * @param schoolLabCompetitionVo 实验室竞赛
     * @return 结果
     */
    @Override
    @Transactional
    public int updateSchoolLabCompetition(SchoolLabCompetitionVo schoolLabCompetitionVo)
    {
        schoolLabCompetitionVo.setUpdateBy(SecurityUtils.getLoginUser().getUser().getUserName());
        schoolLabCompetitionVo.setUpdateTime(DateUtils.getNowDate());
        schoolLabCompetitionMapper.deleteSchoolAccessoryByBusinessId(schoolLabCompetitionVo.getId());
        insertSchoolAccessory(schoolLabCompetitionVo);
        return schoolLabCompetitionMapper.updateSchoolLabCompetition(schoolLabCompetitionVo);
    }

    /**
     * 批量删除实验室竞赛
     *
     * @param ids 需要删除的实验室竞赛主键
     * @return 结果
     */
    @Override
    @Transactional
    public int deleteSchoolLabCompetitionByIds(Long[] ids)
    {
        schoolLabCompetitionMapper.deleteSchoolAccessoryByBusinessIds(ids);
        return schoolLabCompetitionMapper.deleteSchoolLabCompetitionByIds(ids);
    }

    /**
     * 删除实验室竞赛信息
     *
     * @param id 实验室竞赛主键
     * @return 结果
     */
    @Override
    @Transactional
    public int deleteSchoolLabCompetitionById(Long id)
    {
        schoolLabCompetitionMapper.deleteSchoolAccessoryByBusinessId(id);
        return schoolLabCompetitionMapper.deleteSchoolLabCompetitionById(id);
    }

    /**
     * 获取教师
     * @param sysUser
     * @return
     */
    @Override
    public List<Map<String, Object>> getTeacher(SysUser sysUser) {
        return schoolLabCompetitionMapper.getTeacher(sysUser);
    }

    /**
     * 新增证书照片
     * @param
     */
    public void insertSchoolAccessory(SchoolLabCompetitionVo schoolLabCompetitionVo)
    {
        List<SchoolAccessory> schoolAccessoryList = schoolLabCompetitionVo.getSchoolAccessoryList();
        Long id = schoolLabCompetitionVo.getId();
        if (StringUtils.isNotNull(schoolAccessoryList))
        {
            List<SchoolAccessory> list = new ArrayList<SchoolAccessory>();
            for (SchoolAccessory schoolAccessory : schoolAccessoryList)
            {
                schoolAccessory.setModuleName("实验室竞赛");
                schoolAccessory.setAccessoryType("证书照片");
                schoolAccessory.setBusinessId(id);
                schoolAccessory.setCreateBy(SecurityUtils.getLoginUser().getUser().getUserName());
                schoolAccessory.setCreateTime(DateUtils.getNowDate());
                list.add(schoolAccessory);
            }
            if (list.size() > 0)
            {
                schoolLabCompetitionMapper.batchSchoolAccessory(list);
            }
        }
    }
}
