package yangtz.cs.liu.campus.service.impl.schoolInstrument;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolInstrument.SchoolInstrument;
import yangtz.cs.liu.campus.mapper.schoolInstrument.SchoolInstrumentMapper;
import yangtz.cs.liu.campus.service.schoolInstrument.ISchoolInstrumentService;
import yangtz.cs.liu.campus.vo.schoolInstrument.SchoolInstrumentVo;

import java.util.ArrayList;
import java.util.List;

/**
 * 仪器管理Service业务层处理
 *
 * @author ruoyi
 * @date 2023-09-06
 */
@Service
public class SchoolInstrumentServiceImpl extends ServiceImpl<SchoolInstrumentMapper, SchoolInstrument> implements ISchoolInstrumentService {

    @Autowired
    private SchoolInstrumentMapper schoolInstrumentMapper;

    /**
     * 查询仪器管理
     *
     * @param id 仪器管理主键
     * @return 仪器管理
     */
    @Override
    public SchoolInstrument selectSchoolInstrumentById(Long id)
    {
        return schoolInstrumentMapper.selectSchoolInstrumentById(id);
    }

    /**
     * 查询仪器管理列表
     *
     * @param schoolInstrument 仪器管理
     * @return 仪器管理
     */
    @Override
    public List<SchoolInstrument> selectSchoolInstrumentList(SchoolInstrument schoolInstrument)
    {
        return schoolInstrumentMapper.selectSchoolInstrumentList(schoolInstrument);
    }

    /**
     * 新增仪器管理
     *
     * @param schoolInstrument 仪器管理
     * @return 结果
     */
    @Override
    public int insertSchoolInstrument(SchoolInstrument schoolInstrument)
    {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        schoolInstrument.setCreateBy(user.getUserName());
        schoolInstrument.setCreateTime(DateUtils.getNowDate());
        return schoolInstrumentMapper.insertSchoolInstrument(schoolInstrument);
    }

    /**
     * 修改仪器管理
     *
     * @param schoolInstrument 仪器管理
     * @return 结果
     */
    @Override
    public int updateSchoolInstrument(SchoolInstrument schoolInstrument)
    {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        schoolInstrument.setUpdateBy(user.getUserName());
        schoolInstrument.setUpdateTime(DateUtils.getNowDate());
        return schoolInstrumentMapper.updateSchoolInstrument(schoolInstrument);
    }

    /**
     * 批量删除仪器管理
     *
     * @param ids 需要删除的仪器管理主键
     * @return 结果
     */
    @Override
    public int deleteSchoolInstrumentByIds(Long[] ids)
    {
        return schoolInstrumentMapper.deleteSchoolInstrumentByIds(ids);
    }

    /**
     * 删除仪器管理信息
     *
     * @param id 仪器管理主键
     * @return 结果
     */
    @Override
    public int deleteSchoolInstrumentById(Long id)
    {
        return schoolInstrumentMapper.deleteSchoolInstrumentById(id);
    }

    /**
     * 教师借用明细列表
     * @param schoolInstrumentVo
     * @return
     */
    @Override
    public List<SchoolInstrument> selectInstrumentList(SchoolInstrumentVo schoolInstrumentVo) {
        if (StringUtils.isNull(schoolInstrumentVo.getIds()) || schoolInstrumentVo.getIds().size() <= 0){
            schoolInstrumentVo.setIds(null);
        }
        List<SchoolInstrument> list = new ArrayList<>();
        List<SchoolInstrument> schoolInstruments = schoolInstrumentMapper.selectInstrumentList(schoolInstrumentVo);
        for (SchoolInstrument schoolInstrument : schoolInstruments) {
            if (schoolInstrument.getInstrumentNum()==0){
                list.add(schoolInstrument);
            }
        }
        if (list.size() > 0){
            for (SchoolInstrument schoolInstrument : list) {
                schoolInstruments.remove(schoolInstrument);
            }
        }
        return schoolInstruments;
    }
}
