package yangtz.cs.liu.campus.service.impl.schoolInstrument;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolInstrument.SchoolInstrument;
import yangtz.cs.liu.campus.domain.schoolInstrument.SchoolInstrumentClassify;
import yangtz.cs.liu.campus.mapper.schoolInstrument.SchoolInstrumentClassifyMapper;
import yangtz.cs.liu.campus.mapper.schoolInstrument.SchoolInstrumentMapper;
import yangtz.cs.liu.campus.service.schoolInstrument.ISchoolInstrumentClassifyService;

import java.util.List;

/**
 * 仪器药品分类Service业务层处理
 *
 * @author ruoyi
 * @date 2023-09-06
 */
@Service
public class SchoolInstrumentClassifyServiceImpl extends ServiceImpl<SchoolInstrumentClassifyMapper, SchoolInstrumentClassify> implements ISchoolInstrumentClassifyService {

    @Autowired
    private SchoolInstrumentClassifyMapper schoolInstrumentClassifyMapper;
    @Autowired
    private SchoolInstrumentMapper schoolInstrumentMapper;

    /**
     * 查询仪器药品分类
     *
     * @param id 仪器药品分类主键
     * @return 仪器药品分类
     */
    @Override
    public SchoolInstrumentClassify selectSchoolInstrumentClassifyById(Long id)
    {
        return schoolInstrumentClassifyMapper.selectSchoolInstrumentClassifyById(id);
    }

    /**
     * 查询仪器药品分类列表
     *
     * @param schoolInstrumentClassify 仪器药品分类
     * @return 仪器药品分类
     */
    @Override
    public List<SchoolInstrumentClassify> selectSchoolInstrumentClassifyList(SchoolInstrumentClassify schoolInstrumentClassify)
    {
        return schoolInstrumentClassifyMapper.selectSchoolInstrumentClassifyList(schoolInstrumentClassify);
    }

    /**
     * 新增仪器药品分类
     *
     * @param schoolInstrumentClassify 仪器药品分类
     * @return 结果
     */
    @Override
    public int insertSchoolInstrumentClassify(SchoolInstrumentClassify schoolInstrumentClassify)
    {
        //获取登录用户
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //父id
        if (StringUtils.isNotNull(schoolInstrumentClassify.getParentId())){
            SchoolInstrumentClassify instrumentClassify = schoolInstrumentClassifyMapper.selectById(schoolInstrumentClassify.getParentId());
            schoolInstrumentClassify.setAncestors(instrumentClassify.getAncestors() + "," + schoolInstrumentClassify.getParentId());
        }else {
            schoolInstrumentClassify.setParentId((long)0);
            schoolInstrumentClassify.setAncestors("0");
        }
        schoolInstrumentClassify.setCreateBy(user.getUserName());
        schoolInstrumentClassify.setCreateTime(DateUtils.getNowDate());
        return schoolInstrumentClassifyMapper.insert(schoolInstrumentClassify);
    }

    /**
     * 修改仪器药品分类
     *
     * @param schoolInstrumentClassify 仪器药品分类
     * @return 结果
     */
    @Override
    public int updateSchoolInstrumentClassify(SchoolInstrumentClassify schoolInstrumentClassify)
    {
        //获取登录用户
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //父id
        if (StringUtils.isNotNull(schoolInstrumentClassify.getParentId())){
            SchoolInstrumentClassify instrumentClassify = schoolInstrumentClassifyMapper.selectById(schoolInstrumentClassify.getParentId());
            schoolInstrumentClassify.setAncestors(instrumentClassify.getAncestors() + "," + schoolInstrumentClassify.getParentId());
        }else {
            schoolInstrumentClassify.setParentId((long)0);
            schoolInstrumentClassify.setAncestors("0");
        }
        schoolInstrumentClassify.setUpdateBy(user.getUserName());
        schoolInstrumentClassify.setUpdateTime(DateUtils.getNowDate());
        return schoolInstrumentClassifyMapper.updateById(schoolInstrumentClassify);
    }

    /**
     * 批量删除仪器药品分类
     *
     * @param ids 需要删除的仪器药品分类主键
     * @return 结果
     */
    @Override
    public int deleteSchoolInstrumentClassifyByIds(Long[] ids)
    {
        return schoolInstrumentClassifyMapper.deleteSchoolInstrumentClassifyByIds(ids);
    }

    /**
     * 删除仪器药品分类信息
     *
     * @param id 仪器药品分类主键
     * @return 结果
     */
    @Override
    public int deleteSchoolInstrumentClassifyById(Long id)
    {
        //查询该分类下是否有仪器
        LambdaQueryWrapper<SchoolInstrument> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SchoolInstrument::getInstrumentTypeId,id);
        List<SchoolInstrument> list = schoolInstrumentMapper.selectList(wrapper);
        if (list.size() > 0){
            throw new ServiceException("该分类下存在仪器,不可删除");
        }
        return schoolInstrumentClassifyMapper.deleteSchoolInstrumentClassifyById(id);
    }
}
