package yangtz.cs.liu.campus.service.impl.schoolEquipment;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.annotation.DataScope;
import com.ruoyi.common.core.domain.entity.SysRole;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.mapper.SysUserMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolEquipment.SchoolEquipmentLedger;
import yangtz.cs.liu.campus.domain.schoolEquipment.SchoolReceive;
import yangtz.cs.liu.campus.mapper.schoolEquipment.EquipmentLedgerMapper;
import yangtz.cs.liu.campus.mapper.schoolEquipment.ReceiveMapper;
import yangtz.cs.liu.campus.service.schoolEquipment.IReceiveService;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolReceiveVo;

import java.util.ArrayList;
import java.util.List;

@Service
public class ReceiveServiceImpl extends ServiceImpl<ReceiveMapper, SchoolReceive> implements IReceiveService {

    @Autowired
    private ReceiveMapper receiveMapper;
    @Autowired
    private SysUserMapper sysUserMapper;
    @Autowired
    private EquipmentLedgerMapper equipmentLedgerMapper;

    /**
     * 查看设备领用列表
     * @param schoolReceiveVo
     * @return
     */
    @Override
    public List<SchoolReceiveVo> selectSchoolReceiveVoList(SchoolReceiveVo schoolReceiveVo) {
        List<SysRole> roles = SecurityUtils.getLoginUser().getUser().getRoles();
        SysUser user = SecurityUtils.getLoginUser().getUser();
        for (SysRole role : roles) {
            if (role.getRoleKey().equals("admin")){
                return receiveMapper.selectSchoolReceiveVoList(schoolReceiveVo);
            }else if (role.getRoleKey().equals("productCategoryAdmin")){
                schoolReceiveVo.setAdminId(SecurityUtils.getLoginUser().getUser().getUserId());
                return receiveMapper.selectSchoolReceiveVoListGr(schoolReceiveVo);
            }
        }
        if (user.isAdmin()){
            return receiveMapper.selectSchoolReceiveVoList(schoolReceiveVo);
        }
        return new ArrayList<>();
    }

    /**
     * 查看设备领用详细信息
     * @param id
     * @return
     */
    @Override
    public SchoolReceiveVo selectSchoolReceiveVoById(Long id) {
        return receiveMapper.selectSchoolReceiveVoById(id);
    }

    /**
     * 新增设备领用
     * @param schoolReceive
     * @return
     */
    @Override
    public int insertSchoolReceive(SchoolReceive schoolReceive) {
        //判断该设备是否允许借出
        SchoolEquipmentLedger schoolEquipmentLedger1 = equipmentLedgerMapper.selectById(schoolReceive.getEquipmentId());
        if (StringUtils.isNull(schoolEquipmentLedger1)){
            throw new ServiceException("未查询到该设备，请重新输入！");
        }
        if (schoolEquipmentLedger1.getIsAllowLend().equals("0")){
            throw new ServiceException("该设备不允许借出");
        }
        if (StringUtils.isNotNull(schoolReceive.getRecipientById())){
            String userName = sysUserMapper.selectUserById(schoolReceive.getRecipientById()).getUserName();
            schoolReceive.setRecipientBy(userName);
            SchoolEquipmentLedger schoolEquipmentLedger = new SchoolEquipmentLedger();
            schoolEquipmentLedger.setId(schoolReceive.getEquipmentId());
            schoolEquipmentLedger.setAffiliationType("3");
            schoolEquipmentLedger.setUseId(schoolReceive.getRecipientById());
            schoolEquipmentLedger.setUseName(userName);
            equipmentLedgerMapper.updateById(schoolEquipmentLedger);
        }
        if (StringUtils.isNotNull(schoolReceive.getReceivedById())){
            String userName = sysUserMapper.selectUserById(schoolReceive.getReceivedById()).getUserName();
            schoolReceive.setReceivedBy(userName);
        }
        if (StringUtils.isNotNull(schoolReceive.getReturnTime())){
            schoolReceive.setReturnState("1");
            SchoolEquipmentLedger schoolEquipmentLedger = new SchoolEquipmentLedger();
            schoolEquipmentLedger.setId(schoolReceive.getEquipmentId());
            schoolEquipmentLedger.setAffiliationType("2");
            schoolEquipmentLedger.setUseId(null);
            schoolEquipmentLedger.setUseName(null);
            equipmentLedgerMapper.updateById(schoolEquipmentLedger);
        }
        schoolReceive.setCreateBy(SecurityUtils.getLoginUser().getUser().getUserName());
        schoolReceive.setCreateTime(DateUtils.getNowDate());
        return receiveMapper.insert(schoolReceive);
    }

    /**
     * 修改设备领用
     * @param schoolReceive
     * @return
     */
    @Override
    public int updateSchoolReceive(SchoolReceive schoolReceive) {
        if (StringUtils.isNotNull(schoolReceive.getRecipientById())){
            String userName = sysUserMapper.selectUserById(schoolReceive.getRecipientById()).getUserName();
            schoolReceive.setRecipientBy(userName);
            SchoolEquipmentLedger schoolEquipmentLedger = new SchoolEquipmentLedger();
            schoolEquipmentLedger.setId(schoolReceive.getEquipmentId());
            schoolEquipmentLedger.setAffiliationType("3");
            schoolEquipmentLedger.setUseId(schoolReceive.getRecipientById());
            schoolEquipmentLedger.setUseName(userName);
            equipmentLedgerMapper.updateById(schoolEquipmentLedger);
        }
        if (StringUtils.isNotNull(schoolReceive.getReceivedById())){
            String userName = sysUserMapper.selectUserById(schoolReceive.getReceivedById()).getUserName();
            schoolReceive.setReceivedBy(userName);
        }
        if (StringUtils.isNotNull(schoolReceive.getReturnTime())){
            schoolReceive.setReturnState("1");
            SchoolEquipmentLedger schoolEquipmentLedger = new SchoolEquipmentLedger();
            schoolEquipmentLedger.setId(schoolReceive.getEquipmentId());
            schoolEquipmentLedger.setAffiliationType("2");
            schoolEquipmentLedger.setUseId(null);
            schoolEquipmentLedger.setUseName(null);
            equipmentLedgerMapper.updateById(schoolEquipmentLedger);
        }
        schoolReceive.setUpdateBy(SecurityUtils.getLoginUser().getUser().getUserName());
        schoolReceive.setUpdateTime(DateUtils.getNowDate());
        return receiveMapper.updateById(schoolReceive);
    }

    /**
     * 删除设备领用
     * @param ids
     * @return
     */
    @Override
    public int deleteSchoolReceiveByIds(Long[] ids) {
        return receiveMapper.deleteSchoolReceiveByIds(ids);
    }
}
