package yangtz.cs.liu.campus.service.impl.schoolEquipment;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.annotation.DataScope;
import com.ruoyi.common.core.domain.entity.SysRole;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolEquipment.SchoolOutStock;
import yangtz.cs.liu.campus.mapper.schoolEquipment.OutStockMapper;
import yangtz.cs.liu.campus.service.schoolEquipment.IOutStockService;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolOutStockVo;

import java.util.ArrayList;
import java.util.List;

@Service
public class OutStockServiceImpl extends ServiceImpl<OutStockMapper, SchoolOutStock> implements IOutStockService {

    @Autowired
    private OutStockMapper outStockMapper;

    /**
     * 查看设备出库列表
     * @param schoolOutStockVo
     * @return
     */
    @Override
    public List<SchoolOutStockVo> selectSchoolOutStockVoList(SchoolOutStockVo schoolOutStockVo) {
        List<SysRole> roles = SecurityUtils.getLoginUser().getUser().getRoles();
        SysUser user = SecurityUtils.getLoginUser().getUser();
        for (SysRole role : roles) {
            if (role.getRoleKey().equals("admin")){
                return outStockMapper.selectSchoolOutStockVoList(schoolOutStockVo);
            }else if (role.getRoleKey().equals("productCategoryAdmin")){
                schoolOutStockVo.setAdminId(SecurityUtils.getLoginUser().getUser().getUserId());
                return outStockMapper.selectSchoolOutStockVoListGr(schoolOutStockVo);
            }
        }
        if (user.isAdmin()){
            return outStockMapper.selectSchoolOutStockVoList(schoolOutStockVo);
        }
        return new ArrayList<>();
    }

    /**
     * 查看设备出库详细信息
     * @param id
     * @return
     */
    @Override
    public SchoolOutStockVo selectSchoolOutStockVoById(Long id) {
        return outStockMapper.selectSchoolOutStockVoById(id);
    }
}
