package yangtz.cs.liu.campus.service.impl.schoolEquipment;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.annotation.DataScope;
import com.ruoyi.common.core.domain.entity.SysRole;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolEquipment.SchoolInStock;
import yangtz.cs.liu.campus.mapper.schoolEquipment.InStockMapper;
import yangtz.cs.liu.campus.service.schoolEquipment.IInStockService;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolInStockVo;

import java.util.ArrayList;
import java.util.List;

@Service
public class InStockServiceImpl extends ServiceImpl<InStockMapper, SchoolInStock> implements IInStockService {

    @Autowired
    private InStockMapper inStockMapper;

    /**
     * 查看设备入库列表
     * @param schoolInStockVo
     * @return
     */
    @Override
    public List<SchoolInStockVo> selectSchoolInStockVoList(SchoolInStockVo schoolInStockVo) {
        List<SysRole> roles = SecurityUtils.getLoginUser().getUser().getRoles();
        SysUser user = SecurityUtils.getLoginUser().getUser();
        for (SysRole role : roles) {
            if (role.getRoleKey().equals("admin")){
                return inStockMapper.selectSchoolInStockVoList(schoolInStockVo);
            }else if (role.getRoleKey().equals("productCategoryAdmin")){
                schoolInStockVo.setAdminId(SecurityUtils.getLoginUser().getUser().getUserId());
                return inStockMapper.selectSchoolInStockVoListGr(schoolInStockVo);
            }
        }
        if (user.isAdmin()){
            return inStockMapper.selectSchoolInStockVoList(schoolInStockVo);
        }
        return new ArrayList<>();
    }

    /**
     * 查看设备入库详细信息
     * @param id
     * @return
     */
    @Override
    public SchoolInStockVo selectSchoolInStockVoById(Long id) {
        return inStockMapper.selectSchoolInStockVoById(id);
    }


}
