package yangtz.cs.liu.campus.service.impl.schoolDepartmentBudget;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolDepartmentBudget.SchoolDepartmentBudgetProjectmx;
import yangtz.cs.liu.campus.mapper.schoolDepartmentBudget.SchoolDepartmentBudgetProjectmxMapper;
import yangtz.cs.liu.campus.service.schoolDepartmentBudget.ISchoolDepartmentBudgetProjectmxService;

import java.util.List;

/**
 * 科室预算填报项目明细Service业务层处理
 *
 * @author ruoyi
 * @date 2023-07-11
 */
@Service
public class SchoolDepartmentBudgetProjectmxServiceImpl implements ISchoolDepartmentBudgetProjectmxService
{
    @Autowired
    private SchoolDepartmentBudgetProjectmxMapper schoolDepartmentBudgetProjectmxMapper;

    /**
     * 查询科室预算填报项目明细
     *
     * @param id 科室预算填报项目明细主键
     * @return 科室预算填报项目明细
     */
    @Override
    public SchoolDepartmentBudgetProjectmx selectSchoolDepartmentBudgetProjectmxById(Long id)
    {
        return schoolDepartmentBudgetProjectmxMapper.selectSchoolDepartmentBudgetProjectmxById(id);
    }

    /**
     * 查询科室预算填报项目明细列表
     * @param schoolDepartmentBudgetProjectmx 科室预算填报项目明细
     * @return
     */
    @Override
    public List<SchoolDepartmentBudgetProjectmx> selectList(SchoolDepartmentBudgetProjectmx schoolDepartmentBudgetProjectmx) {
        return schoolDepartmentBudgetProjectmxMapper.selectList(schoolDepartmentBudgetProjectmx);
    }















//    /**
//     * 查询科室预算填报项目明细列表
//     *
//     * @param schoolDepartmentBudgetProjectmx 科室预算填报项目明细
//     * @return 科室预算填报项目明细
//     */
//    @Override
//    public List<SchoolDepartmentBudgetProjectmx> selectSchoolDepartmentBudgetProjectmxList(SchoolDepartmentBudgetProjectmx schoolDepartmentBudgetProjectmx)
//    {
//        return schoolDepartmentBudgetProjectmxMapper.selectSchoolDepartmentBudgetProjectmxList(schoolDepartmentBudgetProjectmx);
//    }
//
//    /**
//     * 新增科室预算填报项目明细
//     *
//     * @param schoolDepartmentBudgetProjectmx 科室预算填报项目明细
//     * @return 结果
//     */
//    @Override
//    public int insertSchoolDepartmentBudgetProjectmx(SchoolDepartmentBudgetProjectmx schoolDepartmentBudgetProjectmx)
//    {
//        return schoolDepartmentBudgetProjectmxMapper.insertSchoolDepartmentBudgetProjectmx(schoolDepartmentBudgetProjectmx);
//    }
//
//    /**
//     * 修改科室预算填报项目明细
//     *
//     * @param schoolDepartmentBudgetProjectmx 科室预算填报项目明细
//     * @return 结果
//     */
//    @Override
//    public int updateSchoolDepartmentBudgetProjectmx(SchoolDepartmentBudgetProjectmx schoolDepartmentBudgetProjectmx)
//    {
//        return schoolDepartmentBudgetProjectmxMapper.updateSchoolDepartmentBudgetProjectmx(schoolDepartmentBudgetProjectmx);
//    }
//
//    /**
//     * 批量删除科室预算填报项目明细
//     *
//     * @param ids 需要删除的科室预算填报项目明细主键
//     * @return 结果
//     */
//    @Override
//    public int deleteSchoolDepartmentBudgetProjectmxByIds(Long[] ids)
//    {
//        return schoolDepartmentBudgetProjectmxMapper.deleteSchoolDepartmentBudgetProjectmxByIds(ids);
//    }
//
//    /**
//     * 删除科室预算填报项目明细信息
//     *
//     * @param id 科室预算填报项目明细主键
//     * @return 结果
//     */
//    @Override
//    public int deleteSchoolDepartmentBudgetProjectmxById(Long id)
//    {
//        return schoolDepartmentBudgetProjectmxMapper.deleteSchoolDepartmentBudgetProjectmxById(id);
//    }
}
