package yangtz.cs.liu.campus.service.impl.schoolDcwj;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.constant.DcwjType;
import yangtz.cs.liu.campus.domain.schoolDcwj.SchoolDcwjAn;
import yangtz.cs.liu.campus.domain.schoolDcwj.SchoolDcwjNr;
import yangtz.cs.liu.campus.domain.schoolDcwj.SchoolDcwjPush;
import yangtz.cs.liu.campus.domain.schoolDcwj.SchoolDcwjRy;
import yangtz.cs.liu.campus.domain.schoolXxfb.SchoolXxfbRy;
import yangtz.cs.liu.campus.domain.student.SchoolStudent;
import yangtz.cs.liu.campus.mapper.schoolDcwj.SchoolDcwjAnMapper;
import yangtz.cs.liu.campus.mapper.schoolDcwj.SchoolDcwjNrMapper;
import yangtz.cs.liu.campus.mapper.schoolDcwj.SchoolDcwjPushMapper;
import yangtz.cs.liu.campus.mapper.schoolDcwj.SchoolDcwjRyMapper;
import yangtz.cs.liu.campus.service.schoolDcwj.ISchoolDcwjRyService;
import yangtz.cs.liu.campus.vo.schoolDcwj.*;

import static yangtz.cs.liu.campus.constant.DcwjType.*;

/**
 * 接收人Service业务层处理
 *
 * @author wengxiulin
 * @date 2023-03-01
 */
@Service
public class SchoolDcwjRyServiceImpl extends ServiceImpl<SchoolDcwjRyMapper, SchoolDcwjRy> implements ISchoolDcwjRyService {
    @Autowired
    private SchoolDcwjRyMapper schoolDcwjRyMapper;

    @Autowired
    private SchoolDcwjAnMapper anMapper;

    @Autowired
    private SchoolDcwjNrMapper nrMapper;

    @Autowired
    private SchoolDcwjPushMapper pushMapper;

    //设置单选、多选常量
    //单
    public static final String DANX = "0";
    //多
    public static final String DUOX = "1";

    //格式化小数点，只保留两位
    DecimalFormat format = new DecimalFormat("0.0000");


    /**
     * 查询接收人
     *
     * @param id 接收人主键
     * @return 接收人
     */
    @Override
    public SchoolDcwjRy selectSchoolDcwjRyById(Long id) {
        return schoolDcwjRyMapper.selectSchoolDcwjRyById(id);
    }

    /**
     * 查询接收人列表
     *
     * @param schoolDcwjRy 接收人
     * @return 接收人
     */
    @Override
    public List<SchoolDcwjRy> selectSchoolDcwjRyList(SchoolDcwjRy schoolDcwjRy) {
        return schoolDcwjRyMapper.selectSchoolDcwjRyList(schoolDcwjRy);
    }

    /**
     * 新增接收人
     *
     * @param schoolDcwjRy 接收人
     * @return 结果
     */
    @Override
    public int insertSchoolDcwjRy(SchoolDcwjRy schoolDcwjRy) {
        schoolDcwjRy.setCreateTime(DateUtils.getNowDate());
        return schoolDcwjRyMapper.insertSchoolDcwjRy(schoolDcwjRy);
    }

    /**
     * 修改接收人
     *
     * @param schoolDcwjRy 接收人
     * @return 结果
     */
    @Override
    public int updateSchoolDcwjRy(SchoolDcwjRy schoolDcwjRy) {
        schoolDcwjRy.setUpdateTime(DateUtils.getNowDate());
        return schoolDcwjRyMapper.updateSchoolDcwjRy(schoolDcwjRy);
    }

    /**
     * 批量删除接收人
     *
     * @param ids 需要删除的接收人主键
     * @return 结果
     */
    @Override
    public int deleteSchoolDcwjRyByIds(Long[] ids) {
        return schoolDcwjRyMapper.deleteSchoolDcwjRyByIds(ids);
    }

    /**
     * 删除接收人信息
     *
     * @param id 接收人主键
     * @return 结果
     */
    @Override
    public int deleteSchoolDcwjRyById(Long id) {
        return schoolDcwjRyMapper.deleteSchoolDcwjRyById(id);
    }

    //问卷结果 - 内容获取
    @Override
    public List<SchoolDcwjAnVo> getAnData(Long dcwjId, SchoolDcwjAnVo vo) {
        //获取固定列的值,,获取到的list的id为ry表的id
        List<SchoolDcwjAnVo> list = schoolDcwjRyMapper.getAnData(dcwjId, vo);

        //获取问卷调查题目
        LambdaQueryWrapper<SchoolDcwjNr> nrlqw = new LambdaQueryWrapper<>();
        nrlqw.eq(SchoolDcwjNr::getDcwjId, dcwjId).orderByAsc(SchoolDcwjNr::getNrPx).orderByDesc(SchoolDcwjNr::getCreateTime);
        List<SchoolDcwjNr> nrs = nrMapper.selectList(nrlqw);

        LambdaQueryWrapper<SchoolDcwjAn> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(SchoolDcwjAn::getDcwjId, dcwjId)
        ;
        //a里要么有1个值，要么没有值
        List<SchoolDcwjAn> a = anMapper.selectList(lqw);

        //学生家长调查问卷回答的内容
        for (SchoolDcwjAnVo anVo : list) {
            List<SchoolDcwjAn> ans = new ArrayList<>();
            //设置空对象，是为了，通俗的说就是站位，如果不占位的话，就目前来说，如果用户第一题没写，第二题写了，那么第2题的答案会显示在第1题的位置
            SchoolDcwjAn entity = new SchoolDcwjAn();

            //获取该学生从第一题到最后一题的答案，如果当前题没有答案，，附空值
            for(SchoolDcwjNr nr : nrs){
//                LambdaQueryWrapper<SchoolDcwjAn> lqw = new LambdaQueryWrapper<>();
//                lqw
//                        .eq(SchoolDcwjAn::getDcwjId, dcwjId)
//                        .eq(SchoolDcwjAn::getRyId, anVo.getId())
//                        .eq(SchoolDcwjAn::getNrId, nr.getId())
//                ;
//                //a里要么有1个值，要么没有值
//                List<SchoolDcwjAn> a = anMapper.selectList(lqw);

                for (SchoolDcwjAn schoolDcwjAn : a) {
                    if (schoolDcwjAn.getRyId().equals(anVo.getId()) && schoolDcwjAn.getNrId().equals(nr.getId())){
                        ans.add(a.get(0));
                    }else {
                        ans.add(entity);
                    }
                }

//                if(StringUtils.isNotNull(a) && a.size() > 0){
//                    ans.add(a.get(0));
//                }else {
//                    ans.add(entity);
//                }
            }
            anVo.setList(ans);
        }
        return list;
    }

    //教务-问卷结果 - 内容获取
    @Override
    public List<SchoolDcwjAnVo> getSenateAnData(Long dcwjId, SchoolDcwjAnVo vo) {
        //判断是推送给教师还是家长
        LambdaQueryWrapper<SchoolDcwjPush> pushLqw = new LambdaQueryWrapper<>();
        pushLqw.eq(SchoolDcwjPush::getDcwjId,dcwjId);
        List<SchoolDcwjPush> pushes = pushMapper.selectList(pushLqw);
        if(DcwjType.PUSHT.equals(pushes.get(0).getPubType())){
            //教师
            //获取固定列的值,,获取到的list的id为ry表的id
            List<SchoolDcwjAnVo> list = schoolDcwjRyMapper.getTeaAnData(dcwjId, vo);
            //获取问卷调查题目
            LambdaQueryWrapper<SchoolDcwjNr> nrlqw = new LambdaQueryWrapper<>();
            nrlqw.eq(SchoolDcwjNr::getDcwjId, dcwjId).orderByAsc(SchoolDcwjNr::getNrPx).orderByDesc(SchoolDcwjNr::getCreateTime);
            List<SchoolDcwjNr> nrs = nrMapper.selectList(nrlqw);

            LambdaQueryWrapper<SchoolDcwjAn> lqw = new LambdaQueryWrapper<>();
            lqw
                    .eq(SchoolDcwjAn::getDcwjId, dcwjId)
            ;
            //a里要么有1个值，要么没有值
            List<SchoolDcwjAn> a = anMapper.selectList(lqw);

            //教师调查问卷回答的内容
            for (SchoolDcwjAnVo anVo : list) {
                List<SchoolDcwjAn> ans = new ArrayList<>();
                //设置空对象，是为了，通俗的说就是站位，如果不占位的话，就目前来说，如果用户第一题没写，第二题写了，那么第2题的答案会显示在第1题的位置
                SchoolDcwjAn entity = new SchoolDcwjAn();

                //获取该学生从第一题到最后一题的答案，如果当前题没有答案，，附空值
                for(SchoolDcwjNr nr : nrs){
//                    LambdaQueryWrapper<SchoolDcwjAn> lqw = new LambdaQueryWrapper<>();
//                    lqw
//                            .eq(SchoolDcwjAn::getDcwjId, dcwjId)
//                            .eq(SchoolDcwjAn::getRyId, anVo.getId())
//                            .eq(SchoolDcwjAn::getNrId, nr.getId())
//                    ;
//                    //a里要么有1个值，要么没有值
//                    List<SchoolDcwjAn> a = anMapper.selectList(lqw);

                    for (SchoolDcwjAn schoolDcwjAn : a) {
                        if (schoolDcwjAn.getRyId().equals(anVo.getId()) && schoolDcwjAn.getNrId().equals(nr.getId())){
                            ans.add(schoolDcwjAn);
                        }else {
                            ans.add(entity);
                        }
                    }

//                    if(StringUtils.isNotNull(a) && a.size() > 0){
//                        ans.add(a.get(0));
//                    }else {
//                        ans.add(entity);
//                    }
                }
                anVo.setList(ans);
            }
            return list;
        }

        //推送类型为学生家长
        //获取固定列的值,,获取到的list的id为ry表的id
        List<SchoolDcwjAnVo> list = schoolDcwjRyMapper.getAnData(dcwjId, vo);

        //获取问卷调查题目
        LambdaQueryWrapper<SchoolDcwjNr> nrlqw = new LambdaQueryWrapper<>();
        nrlqw.eq(SchoolDcwjNr::getDcwjId, dcwjId).orderByAsc(SchoolDcwjNr::getNrPx).orderByDesc(SchoolDcwjNr::getCreateTime);
        List<SchoolDcwjNr> nrs = nrMapper.selectList(nrlqw);

        LambdaQueryWrapper<SchoolDcwjAn> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(SchoolDcwjAn::getDcwjId, dcwjId)
        ;
        //a里要么有1个值，要么没有值
        List<SchoolDcwjAn> a = anMapper.selectList(lqw);

        //学生家长调查问卷回答的内容
        for (SchoolDcwjAnVo anVo : list) {
            List<SchoolDcwjAn> ans = new ArrayList<>();
            //设置空对象，是为了，通俗的说就是站位，如果不占位的话，就目前来说，如果用户第一题没写，第二题写了，那么第2题的答案会显示在第1题的位置
            SchoolDcwjAn entity = new SchoolDcwjAn();

            //获取该学生从第一题到最后一题的答案，如果当前题没有答案，，附空值
            for(SchoolDcwjNr nr : nrs){
//                LambdaQueryWrapper<SchoolDcwjAn> lqw = new LambdaQueryWrapper<>();
//                lqw
//                        .eq(SchoolDcwjAn::getDcwjId, dcwjId)
//                        .eq(SchoolDcwjAn::getRyId, anVo.getId())
//                        .eq(SchoolDcwjAn::getNrId, nr.getId())
//                ;
//                //a里要么有1个值，要么没有值
//                List<SchoolDcwjAn> a = anMapper.selectList(lqw);

                for (SchoolDcwjAn schoolDcwjAn : a) {
                    if (schoolDcwjAn.getRyId().equals(anVo.getId()) && schoolDcwjAn.getNrId().equals(nr.getId())){
                        ans.add(schoolDcwjAn);
                    }else {
                        ans.add(entity);
                    }
                }

//                if(StringUtils.isNotNull(a) && a.size() > 0){
//                    ans.add(a.get(0));
//                }else {
//                    ans.add(entity);
//                }
            }
            anVo.setList(ans);
        }
        return list;
    }

    @Override
    public List<SchoolDcwjAnVo> getAnStudentData(Long dcwjId, SchoolDcwjAnVo vo, List<Long> studentIds) {
        //获取固定列的值
        List<SchoolDcwjAnVo> list = schoolDcwjRyMapper.getAnStudentData(dcwjId, vo,studentIds);

        //获取问卷调查题目
        LambdaQueryWrapper<SchoolDcwjNr> nrlqw = new LambdaQueryWrapper<>();
        nrlqw.eq(SchoolDcwjNr::getDcwjId, dcwjId).orderByAsc(SchoolDcwjNr::getNrPx).orderByDesc(SchoolDcwjNr::getCreateTime);
        List<SchoolDcwjNr> nrs = nrMapper.selectList(nrlqw);

        //学生家长调查问卷回答的内容
        for (SchoolDcwjAnVo anVo : list) {
            List<SchoolDcwjAn> ans = new ArrayList<>();
            //设置空对象，是为了，通俗的说就是站位，如果不占位的话，就目前来说，如果用户第一题没写，第二题写了，M那么提尔提的答案会显示咋地一体的位置
            SchoolDcwjAn entity = new SchoolDcwjAn();
            //获取该学生从第一题到最后一题的答案，如果当前题没有答案，，附空值
            for(SchoolDcwjNr nr : nrs){
                LambdaQueryWrapper<SchoolDcwjAn> lqw = new LambdaQueryWrapper<>();
                lqw
                        .eq(SchoolDcwjAn::getDcwjId, dcwjId)
                        .eq(SchoolDcwjAn::getRyId, anVo.getId())
                        .eq(SchoolDcwjAn::getNrId, nr.getId())
                ;
                //a里要么有1个值，要么没有值
                List<SchoolDcwjAn> a = anMapper.selectList(lqw);
                if(StringUtils.isNotNull(a) && a.size() > 0){
                    ans.add(a.get(0));
                }else {
                    ans.add(entity);
                }
            }
            anVo.setList(ans);
        }
        return list;
    }

    @Override
    public List<DcwjRyExportVo> getAnExportData(Long dcwjId, SchoolDcwjAnVo vo,int num) {
        //获取固定列的值
        List<DcwjRyExportVo> list = schoolDcwjRyMapper.getAnExportData(dcwjId, vo);

        //获取问卷调查题目
        LambdaQueryWrapper<SchoolDcwjNr> nrlqw = new LambdaQueryWrapper<>();
        nrlqw.eq(SchoolDcwjNr::getDcwjId, dcwjId).orderByAsc(SchoolDcwjNr::getNrPx).orderByDesc(SchoolDcwjNr::getCreateTime);
        List<SchoolDcwjNr> nrs = nrMapper.selectList(nrlqw);

        int i = 1;
        //学生家长调查问卷回答的内容
        for (DcwjRyExportVo anVo : list) {
            List<SchoolDcwjAn> ans = new ArrayList<>();
            //设置空对象，是为了，通俗的说就是站位，如果不占位的话，就目前来说，如果用户第一题没写，第二题写了，M那么提尔提的答案会显示咋地一体的位置
            SchoolDcwjAn entity = new SchoolDcwjAn();
            //获取该学生从第一题到最后一题的答案，如果当前题没有答案，，附空值
            for(SchoolDcwjNr nr : nrs){
                LambdaQueryWrapper<SchoolDcwjAn> lqw = new LambdaQueryWrapper<>();
                lqw
                        .eq(SchoolDcwjAn::getDcwjId, dcwjId)
                        .eq(SchoolDcwjAn::getRyId, anVo.getId())
                        .eq(SchoolDcwjAn::getNrId, nr.getId())
                ;
                //a里要么有1个值，要么没有值
                List<SchoolDcwjAn> a = anMapper.selectList(lqw);
                if(StringUtils.isNotNull(a) && a.size() > 0){
                    ans.add(a.get(0));
                }else {
                    ans.add(entity);
                }
            }
            anVo.setList(ans);
            anVo.setXh(i++);
        }
        return list;
    }

    //教务-问卷结果-导出教师内容获取
    @Override
    public List<DcwjRyExportVo> getAnExportTeacherData(Long dcwjId, SchoolDcwjAnVo vo, int num) {
        //获取固定列的值
        List<DcwjRyExportVo> list = schoolDcwjRyMapper.getAnExportTeacherData(dcwjId, vo);

        //获取问卷调查题目
        LambdaQueryWrapper<SchoolDcwjNr> nrlqw = new LambdaQueryWrapper<>();
        nrlqw.eq(SchoolDcwjNr::getDcwjId, dcwjId).orderByAsc(SchoolDcwjNr::getNrPx).orderByDesc(SchoolDcwjNr::getCreateTime);
        List<SchoolDcwjNr> nrs = nrMapper.selectList(nrlqw);

        int i = 1;
        //教师调查问卷回答的内容
        for (DcwjRyExportVo anVo : list) {
            List<SchoolDcwjAn> ans = new ArrayList<>();
            //设置空对象，是为了，通俗的说就是站位，如果不占位的话，就目前来说，如果用户第一题没写，第二题写了，M那么提尔提的答案会显示咋地一体的位置
            SchoolDcwjAn entity = new SchoolDcwjAn();
            //获取该学生从第一题到最后一题的答案，如果当前题没有答案，，附空值
            for(SchoolDcwjNr nr : nrs){
                LambdaQueryWrapper<SchoolDcwjAn> lqw = new LambdaQueryWrapper<>();
                lqw
                        .eq(SchoolDcwjAn::getDcwjId, dcwjId)
                        .eq(SchoolDcwjAn::getRyId, anVo.getId())
                        .eq(SchoolDcwjAn::getNrId, nr.getId())
                ;
                //a里要么有1个值，要么没有值
                List<SchoolDcwjAn> a = anMapper.selectList(lqw);
                if(StringUtils.isNotNull(a) && a.size() > 0){
                    ans.add(a.get(0));
                }else {
                    ans.add(entity);
                }
            }
            anVo.setList(ans);
            anVo.setXh(i++);
        }
        return list;
    }

    @Override
    public List<DcwjRyExportVo> getHeaderExportData(Long dcwjId, SchoolDcwjAnVo vo, List<Long> studentIds) {
        //获取固定列的值
        List<DcwjRyExportVo> list = schoolDcwjRyMapper.getHeaderExportData(dcwjId, vo,studentIds);

        //获取问卷调查题目
        LambdaQueryWrapper<SchoolDcwjNr> nrlqw = new LambdaQueryWrapper<>();
        nrlqw.eq(SchoolDcwjNr::getDcwjId, dcwjId).orderByAsc(SchoolDcwjNr::getNrPx).orderByDesc(SchoolDcwjNr::getCreateTime);
        List<SchoolDcwjNr> nrs = nrMapper.selectList(nrlqw);

        int i = 1;
        //学生家长调查问卷回答的内容
        for (DcwjRyExportVo anVo : list) {
            List<SchoolDcwjAn> ans = new ArrayList<>();
            //设置空对象，是为了，通俗的说就是站位，如果不占位的话，就目前来说，如果用户第一题没写，第二题写了，M那么提尔提的答案会显示咋地一体的位置
            SchoolDcwjAn entity = new SchoolDcwjAn();
            //获取该学生从第一题到最后一题的答案，如果当前题没有答案，，附空值
            for(SchoolDcwjNr nr : nrs){
                LambdaQueryWrapper<SchoolDcwjAn> lqw = new LambdaQueryWrapper<>();
                lqw
                        .eq(SchoolDcwjAn::getDcwjId, dcwjId)
                        .eq(SchoolDcwjAn::getRyId, anVo.getId())
                        .eq(SchoolDcwjAn::getNrId, nr.getId())
                ;
                //a里要么有1个值，要么没有值
                List<SchoolDcwjAn> a = anMapper.selectList(lqw);
                if(StringUtils.isNotNull(a) && a.size() > 0){
                    ans.add(a.get(0));
                }else {
                    ans.add(entity);
                }
            }
            anVo.setList(ans);
            anVo.setXh(i++);
        }
        return list;
    }

    //级部-问卷结果-明细数据-详情
    @Override
    public List<DataTVo> getDetails(Long id) {
        List<DataTVo> list = new ArrayList<>();
        SchoolDcwjRy ry = schoolDcwjRyMapper.selectById(id);
        //判断数据是否填写，填了的话，对应an表会有数据，每填an表没数据
        //没填时
        if (FILLINON.equals(ry.getRyZdzt())) {
            //获取调查问卷主键，根据主键再nr表中获取题目信息
            LambdaQueryWrapper<SchoolDcwjNr> nrLqw = new LambdaQueryWrapper<>();
            nrLqw.eq(SchoolDcwjNr::getDcwjId, ry.getDcwjId()).orderByAsc(SchoolDcwjNr::getNrPx).orderByDesc(SchoolDcwjNr::getCreateTime);
            List<SchoolDcwjNr> nrList = nrMapper.selectList(nrLqw);
            for (SchoolDcwjNr nr : nrList) {
                DataTVo tVo = new DataTVo();
                tVo.setType(nr.getNrLx());
                tVo.setTitle(nr.getNrBt());
                list.add(tVo);
            }
        } else {
            //用户已填写
            //获取调查问卷主键，根据主键再nr表中获取题目信息
            LambdaQueryWrapper<SchoolDcwjNr> nrLqw = new LambdaQueryWrapper<>();
            nrLqw.eq(SchoolDcwjNr::getDcwjId, ry.getDcwjId()).orderByAsc(SchoolDcwjNr::getNrPx).orderByDesc(SchoolDcwjNr::getCreateTime);
            List<SchoolDcwjNr> nrList = nrMapper.selectList(nrLqw);
            for (SchoolDcwjNr nr : nrList) {
                DataTVo tVo = new DataTVo();
                tVo.setType(nr.getNrLx());
                tVo.setTitle(nr.getNrBt());
                //获取用户已填写的本题答案 根据ry表主键可以查询出对应an表
                LambdaQueryWrapper<SchoolDcwjAn> lqw = new LambdaQueryWrapper<>();
                lqw
                        .eq(SchoolDcwjAn::getDcwjId, ry.getDcwjId())
                        .eq(SchoolDcwjAn::getRyId, id)
                        .eq(SchoolDcwjAn::getNrId, nr.getId())
                ;
                List<SchoolDcwjAn> anList = anMapper.selectList(lqw);
                if (StringUtils.isNotNull(anList) && anList.size() > 0) {
                    String an = anList.get(0).getUserAnswer();
                    if(DANXUAN.equals(nr.getNrLx())){
                        switch (an){
                            case "A": an = an +". "+ nr.getNrA();break;
                            case "B": an = an +". "+ nr.getNrB();break;
                            case "C": an = an +". "+ nr.getNrC();break;
                            case "D": an = an +". "+ nr.getNrD();break;
                            case "E": an = an +". "+ nr.getNrE();break;
                            case "F": an = an +". "+ nr.getNrF();break;
                            case "G": an = an +". "+ nr.getNrG();break;
                            case "H": an = an +". "+ nr.getNrH();break;
                            case "I": an = an +". "+ nr.getNrI();break;
                            case "J": an = an +". "+ nr.getNrJ();break;
                            case "K": an = an +". "+ nr.getNrK();break;
                            case "L": an = an +". "+ nr.getNrL();break;
                            case "M": an = an +". "+ nr.getNrM();break;
                            case "N": an = an +". "+ nr.getNrN();break;
                            case "O": an = an +". "+ nr.getNrO();break;
                        }
                    }
                    if(DUOXUAN.equals(nr.getNrLx())){
                        //获取多选选择项
                        char ss[] = an.toCharArray();
                        for(char c : ss){
                            switch (c){
                                case 'A': an = c +". "+ nr.getNrA();break;
                                case 'B': an = c +". "+ nr.getNrB();break;
                                case 'C': an = c +". "+ nr.getNrC();break;
                                case 'D': an = c +". "+ nr.getNrD();break;
                                case 'E': an = c +". "+ nr.getNrE();break;
                                case 'F': an = c +". "+ nr.getNrF();break;
                                case 'G': an = c +". "+ nr.getNrG();break;
                                case 'H': an = c +". "+ nr.getNrH();break;
                                case 'I': an = c +". "+ nr.getNrI();break;
                                case 'J': an = c +". "+ nr.getNrJ();break;
                                case 'K': an = c +". "+ nr.getNrK();break;
                                case 'L': an = c +". "+ nr.getNrL();break;
                                case 'M': an = c +". "+ nr.getNrM();break;
                                case 'N': an = c +". "+ nr.getNrN();break;
                                case 'O': an = c +". "+ nr.getNrO();break;
                            }
                            an += "\n";
                        }
                    }
                    tVo.setDatas(an);
                }
                list.add(tVo);
            }
        }
        return list;
    }

    //id为主表id
    @Override
    public List<DataCountVo> getCount(Long id) {
        //返回结果集
        List<DataCountVo> list = new ArrayList<>();
        //查询该调查问卷都有哪些题目
        LambdaQueryWrapper<SchoolDcwjNr> nrLqw = new LambdaQueryWrapper<>();
        nrLqw.eq(SchoolDcwjNr::getDcwjId, id).orderByAsc(SchoolDcwjNr::getNrPx).orderByDesc(SchoolDcwjNr::getCreateTime);
        List<SchoolDcwjNr> nrList = nrMapper.selectList(nrLqw);
        List<SchoolDcwjNr> selectNrList = new ArrayList<>();
        int i = 1;
        //处理题目，，，过滤出选择题
        for (SchoolDcwjNr nr : nrList) {
            nr.setNrBt("第" + i + "题: " + nr.getNrBt());
            if(DANX.equals(nr.getNrLx()) || DUOX.equals(nr.getNrLx())){
                selectNrList.add(nr);
            }
            i++;
        }

        //处理单选、多选小计比例等。。。
        for (SchoolDcwjNr nr : selectNrList) {
            DataCountVo countVo = new DataCountVo();
            //设置标题
            countVo.setTitle(nr.getNrBt());

            //获取本题已填写人数
            LambdaQueryWrapper<SchoolDcwjAn> anWrapper = new LambdaQueryWrapper<>();
            anWrapper
                    .eq(SchoolDcwjAn::getDcwjId,id)
                    .eq(SchoolDcwjAn::getNrId,nr.getId())
                    .isNotNull(SchoolDcwjAn::getUserAnswer)
                    ;
            List<SchoolDcwjAn> effortAns = anMapper.selectList(anWrapper);
            int joinNum = effortAns.size();
            //设置本题已填写人数
            countVo.setNum(joinNum);
            //选项详情
            List<DataCountDetailsVo> detailsVos = new ArrayList<>();
            //单选,选项ABCDEFGHIJKLMNO
            if(DANX.equals(nr.getNrLx())){
                //处理选项A
                if(StringUtils.isNotNull(nr.getNrA()) && !("".equals(nr.getNrA()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrA());
                    //小计（此题有多少你人选择A）
                    //根据主键id,nr_id查询an表，看学员答案有多少A
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .eq(SchoolDcwjAn::getUserAnswer,"A")
                            ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double) aList.size()/joinNum)) * 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项B
                if(StringUtils.isNotNull(nr.getNrB())&& !("".equals(nr.getNrB()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrB());
                    //小计（此题有多少你人选择B）
                    //根据主键id,nr_id查询an表，看学员答案有多少B
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .eq(SchoolDcwjAn::getUserAnswer,"B")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double) aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项C
                if(StringUtils.isNotNull(nr.getNrC())&& !("".equals(nr.getNrC()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrC());
                    //小计（此题有多少你人选择C）
                    //根据主键id,nr_id查询an表，看学员答案有多少C
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .eq(SchoolDcwjAn::getUserAnswer,"C")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double) aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项D
                if(StringUtils.isNotNull(nr.getNrD())&& !("".equals(nr.getNrD()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrD());
                    //小计（此题有多少你人选择D）
                    //根据主键id,nr_id查询an表，看学员答案有多少D
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .eq(SchoolDcwjAn::getUserAnswer,"D")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format( (double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项E
                if(StringUtils.isNotNull(nr.getNrE())&& !("".equals(nr.getNrE()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrE());
                    //小计（此题有多少你人选择A）
                    //根据主键id,nr_id查询an表，看学员答案有多少E
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .eq(SchoolDcwjAn::getUserAnswer,"E")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项F
                if(StringUtils.isNotNull(nr.getNrF())&& !("".equals(nr.getNrF()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrF());
                    //小计（此题有多少你人选择F）
                    //根据主键id,nr_id查询an表，看学员答案有多少F
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .eq(SchoolDcwjAn::getUserAnswer,"F")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项G
                if(StringUtils.isNotNull(nr.getNrG())&& !("".equals(nr.getNrG()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrG());
                    //小计（此题有多少你人选择G）
                    //根据主键id,nr_id查询an表，看学员答案有多少G
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .eq(SchoolDcwjAn::getUserAnswer,"G")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项H
                if(StringUtils.isNotNull(nr.getNrH())&& !("".equals(nr.getNrH()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrH());
                    //小计（此题有多少你人选择H）
                    //根据主键id,nr_id查询an表，看学员答案有多少H
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .eq(SchoolDcwjAn::getUserAnswer,"H")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项I
                if(StringUtils.isNotNull(nr.getNrI())&& !("".equals(nr.getNrI()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrI());
                    //小计（此题有多少你人选择I）
                    //根据主键id,nr_id查询an表，看学员答案有多少I
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .eq(SchoolDcwjAn::getUserAnswer,"I")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项J
                if(StringUtils.isNotNull(nr.getNrJ())&& !("".equals(nr.getNrJ()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrJ());
                    //小计（此题有多少你人选择A）
                    //根据主键id,nr_id查询an表，看学员答案有多少J
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .eq(SchoolDcwjAn::getUserAnswer,"J")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项K
                if(StringUtils.isNotNull(nr.getNrK())&& !("".equals(nr.getNrK()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrK());
                    //小计（此题有多少你人选择K）
                    //根据主键id,nr_id查询an表，看学员答案有多少K
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .eq(SchoolDcwjAn::getUserAnswer,"K")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项L
                if(StringUtils.isNotNull(nr.getNrL())&& !("".equals(nr.getNrL()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrL());
                    //小计（此题有多少你人选择L）
                    //根据主键id,nr_id查询an表，看学员答案有多少L
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .eq(SchoolDcwjAn::getUserAnswer,"L")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项M
                if(StringUtils.isNotNull(nr.getNrM())&& !("".equals(nr.getNrM()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrM());
                    //小计（此题有多少你人选择M）
                    //根据主键id,nr_id查询an表，看学员答案有多少M
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .eq(SchoolDcwjAn::getUserAnswer,"M")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项N
                if(StringUtils.isNotNull(nr.getNrN())&& !("".equals(nr.getNrN()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrN());
                    //小计（此题有多少你人选择N）
                    //根据主键id,nr_id查询an表，看学员答案有多少N
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .eq(SchoolDcwjAn::getUserAnswer,"N")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项O
                if(StringUtils.isNotNull(nr.getNrO())&& !("".equals(nr.getNrO()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrO());
                    //小计（此题有多少你人选择O）
                    //根据主键id,nr_id查询an表，看学员答案有多少O
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .eq(SchoolDcwjAn::getUserAnswer,"O")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }
            }else {
                //多选
                //处理选项A
                if(StringUtils.isNotNull(nr.getNrA())&& !("".equals(nr.getNrA()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrA());
                    //小计（此题有多少你人选择A）
                    //根据主键id,nr_id查询an表，看学员答案有多少A
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .like(SchoolDcwjAn::getUserAnswer,"A")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项B
                if(StringUtils.isNotNull(nr.getNrB())&& !("".equals(nr.getNrB()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrB());
                    //小计（此题有多少你人选择B）
                    //根据主键id,nr_id查询an表，看学员答案有多少B
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .like(SchoolDcwjAn::getUserAnswer,"B")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项C
                if(StringUtils.isNotNull(nr.getNrC())&& !("".equals(nr.getNrC()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrC());
                    //小计（此题有多少你人选择C）
                    //根据主键id,nr_id查询an表，看学员答案有多少C
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .like(SchoolDcwjAn::getUserAnswer,"C")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项D
                if(StringUtils.isNotNull(nr.getNrD())&& !("".equals(nr.getNrD()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrD());
                    //小计（此题有多少你人选择D）
                    //根据主键id,nr_id查询an表，看学员答案有多少D
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .like(SchoolDcwjAn::getUserAnswer,"D")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项E
                if(StringUtils.isNotNull(nr.getNrE())&& !("".equals(nr.getNrE()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrE());
                    //小计（此题有多少你人选择A）
                    //根据主键id,nr_id查询an表，看学员答案有多少E
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .like(SchoolDcwjAn::getUserAnswer,"E")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项F
                if(StringUtils.isNotNull(nr.getNrF())&& !("".equals(nr.getNrF()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrF());
                    //小计（此题有多少你人选择F）
                    //根据主键id,nr_id查询an表，看学员答案有多少F
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .like(SchoolDcwjAn::getUserAnswer,"F")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项G
                if(StringUtils.isNotNull(nr.getNrG())&& !("".equals(nr.getNrG()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrG());
                    //小计（此题有多少你人选择G）
                    //根据主键id,nr_id查询an表，看学员答案有多少G
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .like(SchoolDcwjAn::getUserAnswer,"G")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项H
                if(StringUtils.isNotNull(nr.getNrH())&& !("".equals(nr.getNrH()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrH());
                    //小计（此题有多少你人选择H）
                    //根据主键id,nr_id查询an表，看学员答案有多少H
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .like(SchoolDcwjAn::getUserAnswer,"H")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项I
                if(StringUtils.isNotNull(nr.getNrI())&& !("".equals(nr.getNrI()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrI());
                    //小计（此题有多少你人选择I）
                    //根据主键id,nr_id查询an表，看学员答案有多少I
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .like(SchoolDcwjAn::getUserAnswer,"I")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项J
                if(StringUtils.isNotNull(nr.getNrJ())&& !("".equals(nr.getNrJ()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrJ());
                    //小计（此题有多少你人选择A）
                    //根据主键id,nr_id查询an表，看学员答案有多少J
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .like(SchoolDcwjAn::getUserAnswer,"J")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项K
                if(StringUtils.isNotNull(nr.getNrK())&& !("".equals(nr.getNrK()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrK());
                    //小计（此题有多少你人选择K）
                    //根据主键id,nr_id查询an表，看学员答案有多少K
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .like(SchoolDcwjAn::getUserAnswer,"K")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项L
                if(StringUtils.isNotNull(nr.getNrL())&& !("".equals(nr.getNrL()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrL());
                    //小计（此题有多少你人选择L）
                    //根据主键id,nr_id查询an表，看学员答案有多少L
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .like(SchoolDcwjAn::getUserAnswer,"L")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项M
                if(StringUtils.isNotNull(nr.getNrM())&& !("".equals(nr.getNrM()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrM());
                    //小计（此题有多少你人选择M）
                    //根据主键id,nr_id查询an表，看学员答案有多少M
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .like(SchoolDcwjAn::getUserAnswer,"M")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项N
                if(StringUtils.isNotNull(nr.getNrN())&& !("".equals(nr.getNrN()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrN());
                    //小计（此题有多少你人选择N）
                    //根据主键id,nr_id查询an表，看学员答案有多少N
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .like(SchoolDcwjAn::getUserAnswer,"N")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项O
                if(StringUtils.isNotNull(nr.getNrO())&& !("".equals(nr.getNrO()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrO());
                    //小计（此题有多少你人选择O）
                    //根据主键id,nr_id查询an表，看学员答案有多少O
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .like(SchoolDcwjAn::getUserAnswer,"O")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }
            }
            countVo.setDetailsLit(detailsVos);
            list.add(countVo);
        }
        return list;
    }

    //班主任-问卷结果-统计
    @Override
    public List<DataCountVo> getHeaderCount(Long id,List<Long> studentIds) {
        //返回结果集
        List<DataCountVo> list = new ArrayList<>();
        //查询该调查问卷都有哪些题目
        LambdaQueryWrapper<SchoolDcwjNr> nrLqw = new LambdaQueryWrapper<>();
        nrLqw.eq(SchoolDcwjNr::getDcwjId, id).orderByAsc(SchoolDcwjNr::getNrPx).orderByDesc(SchoolDcwjNr::getCreateTime);
        List<SchoolDcwjNr> nrList = nrMapper.selectList(nrLqw);
        List<SchoolDcwjNr> selectNrList = new ArrayList<>();
        int i = 1;
        //处理题目，，，过滤出选择题
        for (SchoolDcwjNr nr : nrList) {
            nr.setNrBt("第" + i + "题: " + nr.getNrBt());
            if(DANX.equals(nr.getNrLx()) || DUOX.equals(nr.getNrLx())){
                selectNrList.add(nr);
            }
            i++;
        }

        //获取schoolDcwjRy中根据主键id和学生ID查出来的id
        LambdaQueryWrapper<SchoolDcwjRy> ryLqw = new LambdaQueryWrapper<>();
        ryLqw
                .eq(SchoolDcwjRy::getDcwjId,id)
                .in(SchoolDcwjRy::getStudentId,studentIds);
        List<SchoolDcwjRy> ryList = schoolDcwjRyMapper.selectList(ryLqw);
        if(StringUtils.isNull(ryList) || ryList.size() == 0){
            return new ArrayList<>();
        }
        //获取学生id
        List<Long> ryIds = ryList.stream().map(SchoolDcwjRy::getId).distinct().collect(Collectors.toList());

        //处理单选、多选小计比例等。。。
        for (SchoolDcwjNr nr : selectNrList) {
            DataCountVo countVo = new DataCountVo();
            //设置标题
            countVo.setTitle(nr.getNrBt());

            //获取本题已填写人数
            LambdaQueryWrapper<SchoolDcwjAn> anWrapper = new LambdaQueryWrapper<>();
            anWrapper
                    .eq(SchoolDcwjAn::getDcwjId,id)
                    .eq(SchoolDcwjAn::getNrId,nr.getId())
                    .in(SchoolDcwjAn::getRyId,ryIds)
                    .isNotNull(SchoolDcwjAn::getUserAnswer)
            ;
            List<SchoolDcwjAn> effortAns = anMapper.selectList(anWrapper);
            int joinNum = effortAns.size();
            //设置本题已填写人数
            countVo.setNum(joinNum);
            //选项详情
            List<DataCountDetailsVo> detailsVos = new ArrayList<>();
            //单选,选项ABCDEFGHIJKLMNO
            if(DANX.equals(nr.getNrLx())){
                //处理选项A
                if(StringUtils.isNotNull(nr.getNrA())&& !("".equals(nr.getNrA()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrA());
                    //小计（此题有多少你人选择A）
                    //根据主键id,nr_id查询an表，看学员答案有多少A
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .in(SchoolDcwjAn::getRyId,ryIds)
                            .eq(SchoolDcwjAn::getUserAnswer,"A")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double) aList.size()/joinNum)) * 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项B
                if(StringUtils.isNotNull(nr.getNrB())&& !("".equals(nr.getNrB()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrB());
                    //小计（此题有多少你人选择B）
                    //根据主键id,nr_id查询an表，看学员答案有多少B
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .in(SchoolDcwjAn::getRyId,ryIds)
                            .eq(SchoolDcwjAn::getUserAnswer,"B")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double) aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项C
                if(StringUtils.isNotNull(nr.getNrC())&& !("".equals(nr.getNrC()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrC());
                    //小计（此题有多少你人选择C）
                    //根据主键id,nr_id查询an表，看学员答案有多少C
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .in(SchoolDcwjAn::getRyId,ryIds)
                            .eq(SchoolDcwjAn::getUserAnswer,"C")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double) aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项D
                if(StringUtils.isNotNull(nr.getNrD())&& !("".equals(nr.getNrD()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrD());
                    //小计（此题有多少你人选择D）
                    //根据主键id,nr_id查询an表，看学员答案有多少D
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .in(SchoolDcwjAn::getRyId,ryIds)
                            .eq(SchoolDcwjAn::getUserAnswer,"D")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format( (double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项E
                if(StringUtils.isNotNull(nr.getNrE())&& !("".equals(nr.getNrE()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrE());
                    //小计（此题有多少你人选择A）
                    //根据主键id,nr_id查询an表，看学员答案有多少E
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .in(SchoolDcwjAn::getRyId,ryIds)
                            .eq(SchoolDcwjAn::getUserAnswer,"E")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项F
                if(StringUtils.isNotNull(nr.getNrF())&& !("".equals(nr.getNrF()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrF());
                    //小计（此题有多少你人选择F）
                    //根据主键id,nr_id查询an表，看学员答案有多少F
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .in(SchoolDcwjAn::getRyId,ryIds)
                            .eq(SchoolDcwjAn::getUserAnswer,"F")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项G
                if(StringUtils.isNotNull(nr.getNrG())&& !("".equals(nr.getNrG()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrG());
                    //小计（此题有多少你人选择G）
                    //根据主键id,nr_id查询an表，看学员答案有多少G
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .in(SchoolDcwjAn::getRyId,ryIds)
                            .eq(SchoolDcwjAn::getUserAnswer,"G")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项H
                if(StringUtils.isNotNull(nr.getNrH())&& !("".equals(nr.getNrH()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrH());
                    //小计（此题有多少你人选择H）
                    //根据主键id,nr_id查询an表，看学员答案有多少H
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .in(SchoolDcwjAn::getRyId,ryIds)
                            .eq(SchoolDcwjAn::getUserAnswer,"H")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项I
                if(StringUtils.isNotNull(nr.getNrI())&& !("".equals(nr.getNrI()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrI());
                    //小计（此题有多少你人选择I）
                    //根据主键id,nr_id查询an表，看学员答案有多少I
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .in(SchoolDcwjAn::getRyId,ryIds)
                            .eq(SchoolDcwjAn::getUserAnswer,"I")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项J
                if(StringUtils.isNotNull(nr.getNrJ())&& !("".equals(nr.getNrJ()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrJ());
                    //小计（此题有多少你人选择A）
                    //根据主键id,nr_id查询an表，看学员答案有多少J
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .in(SchoolDcwjAn::getRyId,ryIds)
                            .eq(SchoolDcwjAn::getUserAnswer,"J")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项K
                if(StringUtils.isNotNull(nr.getNrK())&& !("".equals(nr.getNrK()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrK());
                    //小计（此题有多少你人选择K）
                    //根据主键id,nr_id查询an表，看学员答案有多少K
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .in(SchoolDcwjAn::getRyId,ryIds)
                            .eq(SchoolDcwjAn::getUserAnswer,"K")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项L
                if(StringUtils.isNotNull(nr.getNrL())&& !("".equals(nr.getNrL()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrL());
                    //小计（此题有多少你人选择L）
                    //根据主键id,nr_id查询an表，看学员答案有多少L
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .in(SchoolDcwjAn::getRyId,ryIds)
                            .eq(SchoolDcwjAn::getUserAnswer,"L")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项M
                if(StringUtils.isNotNull(nr.getNrM())&& !("".equals(nr.getNrM()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrM());
                    //小计（此题有多少你人选择M）
                    //根据主键id,nr_id查询an表，看学员答案有多少M
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .in(SchoolDcwjAn::getRyId,ryIds)
                            .eq(SchoolDcwjAn::getUserAnswer,"M")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项N
                if(StringUtils.isNotNull(nr.getNrN())&& !("".equals(nr.getNrN()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrN());
                    //小计（此题有多少你人选择N）
                    //根据主键id,nr_id查询an表，看学员答案有多少N
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .in(SchoolDcwjAn::getRyId,ryIds)
                            .eq(SchoolDcwjAn::getUserAnswer,"N")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项O
                if(StringUtils.isNotNull(nr.getNrO())&& !("".equals(nr.getNrO()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrO());
                    //小计（此题有多少你人选择O）
                    //根据主键id,nr_id查询an表，看学员答案有多少O
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                            .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .in(SchoolDcwjAn::getRyId,ryIds)
                            .eq(SchoolDcwjAn::getUserAnswer,"O")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }
            }else {
                //多选
                //处理选项A
                if(StringUtils.isNotNull(nr.getNrA())&& !("".equals(nr.getNrA()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrA());
                    //小计（此题有多少你人选择A）
                    //根据主键id,nr_id查询an表，看学员答案有多少A
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                             .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .in(SchoolDcwjAn::getRyId,ryIds)
                            .like(SchoolDcwjAn::getUserAnswer,"A")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项B
                if(StringUtils.isNotNull(nr.getNrB())&& !("".equals(nr.getNrB()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrB());
                    //小计（此题有多少你人选择B）
                    //根据主键id,nr_id查询an表，看学员答案有多少B
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                             .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .in(SchoolDcwjAn::getRyId,ryIds)
                            .like(SchoolDcwjAn::getUserAnswer,"B")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项C
                if(StringUtils.isNotNull(nr.getNrC())&& !("".equals(nr.getNrC()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrC());
                    //小计（此题有多少你人选择C）
                    //根据主键id,nr_id查询an表，看学员答案有多少C
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                             .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .in(SchoolDcwjAn::getRyId,ryIds)
                            .like(SchoolDcwjAn::getUserAnswer,"C")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项D
                if(StringUtils.isNotNull(nr.getNrD())&& !("".equals(nr.getNrD()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrD());
                    //小计（此题有多少你人选择D）
                    //根据主键id,nr_id查询an表，看学员答案有多少D
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                             .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .in(SchoolDcwjAn::getRyId,ryIds)
                            .like(SchoolDcwjAn::getUserAnswer,"D")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项E
                if(StringUtils.isNotNull(nr.getNrE())&& !("".equals(nr.getNrE()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrE());
                    //小计（此题有多少你人选择A）
                    //根据主键id,nr_id查询an表，看学员答案有多少E
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                             .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .in(SchoolDcwjAn::getRyId,ryIds)
                            .like(SchoolDcwjAn::getUserAnswer,"E")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项F
                if(StringUtils.isNotNull(nr.getNrF())&& !("".equals(nr.getNrF()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrF());
                    //小计（此题有多少你人选择F）
                    //根据主键id,nr_id查询an表，看学员答案有多少F
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                             .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .in(SchoolDcwjAn::getRyId,ryIds)
                            .like(SchoolDcwjAn::getUserAnswer,"F")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项G
                if(StringUtils.isNotNull(nr.getNrG())&& !("".equals(nr.getNrG()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrG());
                    //小计（此题有多少你人选择G）
                    //根据主键id,nr_id查询an表，看学员答案有多少G
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                             .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .in(SchoolDcwjAn::getRyId,ryIds)
                            .like(SchoolDcwjAn::getUserAnswer,"G")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项H
                if(StringUtils.isNotNull(nr.getNrH())&& !("".equals(nr.getNrH()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrH());
                    //小计（此题有多少你人选择H）
                    //根据主键id,nr_id查询an表，看学员答案有多少H
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                             .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .in(SchoolDcwjAn::getRyId,ryIds)
                            .like(SchoolDcwjAn::getUserAnswer,"H")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项I
                if(StringUtils.isNotNull(nr.getNrI())&& !("".equals(nr.getNrI()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrI());
                    //小计（此题有多少你人选择I）
                    //根据主键id,nr_id查询an表，看学员答案有多少I
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                             .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .in(SchoolDcwjAn::getRyId,ryIds)
                            .like(SchoolDcwjAn::getUserAnswer,"I")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项J
                if(StringUtils.isNotNull(nr.getNrJ())&& !("".equals(nr.getNrJ()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrJ());
                    //小计（此题有多少你人选择A）
                    //根据主键id,nr_id查询an表，看学员答案有多少J
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                             .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .in(SchoolDcwjAn::getRyId,ryIds)
                            .like(SchoolDcwjAn::getUserAnswer,"J")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项K
                if(StringUtils.isNotNull(nr.getNrK())&& !("".equals(nr.getNrK()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrK());
                    //小计（此题有多少你人选择K）
                    //根据主键id,nr_id查询an表，看学员答案有多少K
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                             .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .in(SchoolDcwjAn::getRyId,ryIds)
                            .like(SchoolDcwjAn::getUserAnswer,"K")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项L
                if(StringUtils.isNotNull(nr.getNrL())&& !("".equals(nr.getNrL()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrL());
                    //小计（此题有多少你人选择L）
                    //根据主键id,nr_id查询an表，看学员答案有多少L
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                             .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .in(SchoolDcwjAn::getRyId,ryIds)
                            .like(SchoolDcwjAn::getUserAnswer,"L")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项M
                if(StringUtils.isNotNull(nr.getNrM())&& !("".equals(nr.getNrM()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrM());
                    //小计（此题有多少你人选择M）
                    //根据主键id,nr_id查询an表，看学员答案有多少M
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                             .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .in(SchoolDcwjAn::getRyId,ryIds)
                            .like(SchoolDcwjAn::getUserAnswer,"M")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项N
                if(StringUtils.isNotNull(nr.getNrN())&& !("".equals(nr.getNrN()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrN());
                    //小计（此题有多少你人选择N）
                    //根据主键id,nr_id查询an表，看学员答案有多少N
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                             .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .in(SchoolDcwjAn::getRyId,ryIds)
                            .like(SchoolDcwjAn::getUserAnswer,"N")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }

                //处理选项O
                if(StringUtils.isNotNull(nr.getNrO())&& !("".equals(nr.getNrO()))){
                    DataCountDetailsVo detailsVo = new DataCountDetailsVo();
                    //选项内容
                    detailsVo.setSelects(nr.getNrO());
                    //小计（此题有多少你人选择O）
                    //根据主键id,nr_id查询an表，看学员答案有多少O
                    LambdaQueryWrapper<SchoolDcwjAn> anlqw = new LambdaQueryWrapper<>();
                    anlqw
                            .eq(SchoolDcwjAn::getDcwjId,id)
                             .eq(SchoolDcwjAn::getNrId,nr.getId())
                            .in(SchoolDcwjAn::getRyId,ryIds)
                            .like(SchoolDcwjAn::getUserAnswer,"O")
                    ;
                    List<SchoolDcwjAn> aList = anMapper.selectList(anlqw);
                    detailsVo.setSelectNum(aList.size());
                    //如果参与人数 = 0
                    if(0 == joinNum){
                        detailsVo.setProportion(0);
                    }else{
                        detailsVo.setProportion(Double.parseDouble(format.format((double)aList.size()/joinNum))* 100);
                    }
                    detailsVos.add(detailsVo);
                }
            }
            countVo.setDetailsLit(detailsVos);
            list.add(countVo);
        }
        return list;
    }

    @Override
    public List<SchoolDcwjAnVo> getTeaAnData(Long dcwjId, SchoolDcwjAnVo vo) {
        return schoolDcwjRyMapper.getTeaAnData(dcwjId,vo);
    }

    @Override
    public List<SchoolDcwjAnVo> getAnData1(Long dcwjId, SchoolDcwjAnVo vo) {
        return schoolDcwjRyMapper.getAnData(dcwjId,vo);
    }

    /**
     * 批量新增接收人（家长）
     * @param schoolDcwjRyList
     * @return
     */
    @Override
    public int batchInsertDcwjRyStudent(List<SchoolDcwjRy> schoolDcwjRyList) {
        return schoolDcwjRyMapper.batchInsertDcwjRyStudent(schoolDcwjRyList);
    }
}
